
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.storage.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentList;

import java.util.Map;
import java.util.TreeMap;


public class VolumeAttachmentOperationsImpl extends HasMetadataOperation<VolumeAttachment, VolumeAttachmentList, Resource<VolumeAttachment>> {

  public VolumeAttachmentOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public VolumeAttachmentOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public VolumeAttachmentOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("volumeattachments"));
    this.type = VolumeAttachment.class;
    this.listType = VolumeAttachmentList.class;
  }

  public VolumeAttachmentOperationsImpl newInstance(OperationContext context) {
    return new VolumeAttachmentOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
