
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;

import java.util.Map;
import java.util.TreeMap;


public class ServiceAccountOperationsImpl extends HasMetadataOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> {

  public ServiceAccountOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public ServiceAccountOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ServiceAccountOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("serviceaccounts"));
    this.type = ServiceAccount.class;
    this.listType = ServiceAccountList.class;
  }

  public ServiceAccountOperationsImpl newInstance(OperationContext context) {
    return new ServiceAccountOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
