
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;

import java.util.Map;
import java.util.TreeMap;


public class PersistentVolumeClaimOperationsImpl extends HasMetadataOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> {

  public PersistentVolumeClaimOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PersistentVolumeClaimOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PersistentVolumeClaimOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("persistentvolumeclaims"));
    this.type = PersistentVolumeClaim.class;
    this.listType = PersistentVolumeClaimList.class;
  }

  public PersistentVolumeClaimOperationsImpl newInstance(OperationContext context) {
    return new PersistentVolumeClaimOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
