
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.admissionregistration.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfigurationList;

import java.util.Map;
import java.util.TreeMap;


public class MutatingWebhookConfigurationOperationsImpl extends HasMetadataOperation<MutatingWebhookConfiguration, MutatingWebhookConfigurationList, Resource<MutatingWebhookConfiguration>> {

  public MutatingWebhookConfigurationOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public MutatingWebhookConfigurationOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public MutatingWebhookConfigurationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("admissionregistration.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("mutatingwebhookconfigurations"));
    this.type = MutatingWebhookConfiguration.class;
    this.listType = MutatingWebhookConfigurationList.class;
  }

  public MutatingWebhookConfigurationOperationsImpl newInstance(OperationContext context) {
    return new MutatingWebhookConfigurationOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
