
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;

import java.util.Map;
import java.util.TreeMap;


public class DaemonSetOperationsImpl extends HasMetadataOperation<DaemonSet, DaemonSetList, Resource<DaemonSet>> {

  public DaemonSetOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public DaemonSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public DaemonSetOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("extensions")
    .withApiGroupVersion("v1beta1")
    .withPlural("daemonsets"));
    this.type = DaemonSet.class;
    this.listType = DaemonSetList.class;
  }

  public DaemonSetOperationsImpl newInstance(OperationContext context) {
    return new DaemonSetOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
