/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CustomResourceOperationsImplTest {
    private final CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("custom.name")).endMetadata()).withNewSpec().withGroup("custom.group")).withVersion("v1alpha1")).withNewNames().withKind("MyCustomResource")).withListKind("MyCustomResourceList")).withPlural("mycustomresources")).withSingular("mycustomresource")).endNames()).endSpec()).build();
    private final CustomResourceOperationContext context = new CustomResourceOperationContext().withCrd((Object)this.crd).withType(MyCustomResource.class).withListType(MyCustomResourceList.class);

    @Test
    public void shouldRegisterWithKubernetesDeserializer() throws IOException {
        new CustomResourceOperationsImpl(this.context);
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createParser("{\n    \"apiVersion\": \"custom.group/v1alpha1\",\n    \"kind\": \"MyCustomResource\"\n}");
        KubernetesDeserializer deserializer = new KubernetesDeserializer();
        KubernetesResource resource = deserializer.deserialize(parser, null);
        Assert.assertThat((Object)resource, (Matcher)IsInstanceOf.instanceOf(MyCustomResource.class));
        Assert.assertEquals((Object)"custom.group/v1alpha1", (Object)((MyCustomResource)resource).getApiVersion());
    }

    public static class MyCustomResourceList
    extends CustomResourceList<MyCustomResource> {
    }

    public static class MyCustomResource
    extends CustomResource {
    }
}

