/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class SerializationTest {
    @Test
    @DisplayName(value="unmarshal, String containing List with windows like line-ends (CRLF), all list items should be available")
    void unmarshalListWithWindowsLineSeparatorsString() throws Exception {
        List<String> fileLines = Files.readAllLines(new File(SerializationTest.class.getResource("/test-list.yml").getFile()).toPath(), StandardCharsets.UTF_8);
        String crlfFile = String.join((CharSequence)" \r\n", fileLines);
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)crlfFile, KubernetesResource.class);
        Assert.assertTrue((boolean)(result instanceof KubernetesList));
        KubernetesList kubernetesList = (KubernetesList)result;
        Assert.assertEquals((long)2L, (long)kubernetesList.getItems().size());
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(0) instanceof Service));
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(1) instanceof Deployment));
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with windows line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with windows line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n");
        Assert.assertFalse((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with linux line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with linux line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n");
        Assert.assertFalse((boolean)result);
    }
}

