/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.authorization.SubjectAccessReview;
import io.fabric8.kubernetes.api.model.batch.CronJob;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.discovery.EndpointSlice;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicy;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClass;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class UtilsTest {
    @Test
    public void existingSysPropShouldReturnValue() {
        System.setProperty("something", "value");
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"something"));
        System.getProperties().remove("something");
    }

    @Test
    public void missingSysPropAndEnvVarShouldReturnNull() {
        Assertions.assertNull((Object)Utils.getSystemPropertyOrEnvVar((String)"doesn't exist"));
    }

    @Test
    public void existingEnvVarShouldReturnValue() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"ENV_VAR_EXISTS"));
    }

    @Test
    public void existingEnvVarShouldReturnValueFromConvertedSysPropName() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists"));
    }

    @Test
    public void existingEnvVarShouldReturnBooleanValueFromConvertedSysPropName() {
        Assertions.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists.boolean", (Boolean)false));
    }

    @Test
    public void missingEnvVarShouldReturnDefaultValue() {
        Assertions.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"DONT_EXIST", (Boolean)true));
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and empty parameters, should return input")
    public void interpolateStringTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.emptyMap());
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameters, should return input")
    public void interpolateStringNullParametersTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", null);
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameter values, should return input")
    public void interpolateStringNullParameterValuesTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.singletonMap("KEY", null));
        Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with mixed placeholders and parameters, should return interpolated input")
    public void interpolateStringWithParametersTest() {
        String input = "This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SINGLE_CURLY_BRACE", "template string");
        parameters.put("RENDER_UNQUOTED", "'1' === '1';");
        parameters.put("ALREADY_UNQUOTED", "/* END */");
        parameters.put("NOT_THERE", "/* END */");
        parameters.put(null, "NULL key is ignored");
        parameters.put("NULL_VALUE", null);
        String result = Utils.interpolateString((String)"This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}", parameters);
        Assertions.assertEquals((Object)"This is a \"template string\" and the following is code ${NOT_REPLACED}: '1' === '1'; /* END */", (Object)result);
    }

    @Test
    public void testGetPluralFromKind() {
        HashMap<String, Class> pluralToKubernetesResourceMap = new HashMap<String, Class>();
        pluralToKubernetesResourceMap.put("bindings", Binding.class);
        pluralToKubernetesResourceMap.put("componentstatuses", ComponentStatus.class);
        pluralToKubernetesResourceMap.put("configmaps", ConfigMap.class);
        pluralToKubernetesResourceMap.put("endpoints", Endpoints.class);
        pluralToKubernetesResourceMap.put("events", Event.class);
        pluralToKubernetesResourceMap.put("limitranges", LimitRange.class);
        pluralToKubernetesResourceMap.put("namespaces", Namespace.class);
        pluralToKubernetesResourceMap.put("nodes", Node.class);
        pluralToKubernetesResourceMap.put("persistentvolumeclaims", PersistentVolumeClaim.class);
        pluralToKubernetesResourceMap.put("persistentvolumes", PersistentVolume.class);
        pluralToKubernetesResourceMap.put("pods", Pod.class);
        pluralToKubernetesResourceMap.put("podtemplates", PodTemplate.class);
        pluralToKubernetesResourceMap.put("replicationcontrollers", ReplicationController.class);
        pluralToKubernetesResourceMap.put("resourcequotas", ResourceQuota.class);
        pluralToKubernetesResourceMap.put("secrets", Secret.class);
        pluralToKubernetesResourceMap.put("serviceaccounts", ServiceAccount.class);
        pluralToKubernetesResourceMap.put("services", Service.class);
        pluralToKubernetesResourceMap.put("mutatingwebhookconfigurations", MutatingWebhookConfiguration.class);
        pluralToKubernetesResourceMap.put("validatingwebhookconfigurations", ValidatingWebhookConfiguration.class);
        pluralToKubernetesResourceMap.put("customresourcedefinitions", CustomResourceDefinition.class);
        pluralToKubernetesResourceMap.put("controllerrevisions", ControllerRevision.class);
        pluralToKubernetesResourceMap.put("daemonsets", DaemonSet.class);
        pluralToKubernetesResourceMap.put("deployments", Deployment.class);
        pluralToKubernetesResourceMap.put("replicasets", ReplicaSet.class);
        pluralToKubernetesResourceMap.put("statefulsets", StatefulSet.class);
        pluralToKubernetesResourceMap.put("tokenreviews", TokenReview.class);
        pluralToKubernetesResourceMap.put("localsubjectaccessreviews", LocalSubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("selfsubjectaccessreviews", SelfSubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("selfsubjectrulesreviews", SelfSubjectRulesReview.class);
        pluralToKubernetesResourceMap.put("subjectaccessreviews", SubjectAccessReview.class);
        pluralToKubernetesResourceMap.put("horizontalpodautoscalers", HorizontalPodAutoscaler.class);
        pluralToKubernetesResourceMap.put("cronjobs", CronJob.class);
        pluralToKubernetesResourceMap.put("jobs", Job.class);
        pluralToKubernetesResourceMap.put("certificatesigningrequests", CertificateSigningRequest.class);
        pluralToKubernetesResourceMap.put("leases", Lease.class);
        pluralToKubernetesResourceMap.put("endpointslices", EndpointSlice.class);
        pluralToKubernetesResourceMap.put("ingresses", Ingress.class);
        pluralToKubernetesResourceMap.put("networkpolicies", NetworkPolicy.class);
        pluralToKubernetesResourceMap.put("poddisruptionbudgets", PodDisruptionBudget.class);
        pluralToKubernetesResourceMap.put("podsecuritypolicies", PodSecurityPolicy.class);
        pluralToKubernetesResourceMap.put("clusterrolebindings", ClusterRoleBinding.class);
        pluralToKubernetesResourceMap.put("clusterroles", ClusterRole.class);
        pluralToKubernetesResourceMap.put("rolebindings", RoleBinding.class);
        pluralToKubernetesResourceMap.put("roles", Role.class);
        pluralToKubernetesResourceMap.put("priorityclasses", PriorityClass.class);
        pluralToKubernetesResourceMap.put("csidrivers", CSIDriver.class);
        pluralToKubernetesResourceMap.put("csinodes", CSINode.class);
        pluralToKubernetesResourceMap.put("storageclasses", StorageClass.class);
        pluralToKubernetesResourceMap.put("volumeattachments", VolumeAttachment.class);
        pluralToKubernetesResourceMap.forEach((plural, kubernetesResource) -> Assertions.assertEquals((Object)plural, (Object)Utils.getPluralFromKind((String)kubernetesResource.getSimpleName())));
    }
}

