
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.settings.DoneablePodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPresetList;
import io.fabric8.kubernetes.api.model.settings.DoneablePodPreset;

import java.util.Map;
import java.util.TreeMap;


public class PodPresetOperationsImpl extends HasMetadataOperation<PodPreset, PodPresetList, DoneablePodPreset, Resource<PodPreset, DoneablePodPreset>> {

  public PodPresetOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PodPresetOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
  }

  public PodPresetOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("settings.k8s.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("podpresets"));
    this.type = PodPreset.class;
    this.listType = PodPresetList.class;
    this.doneableType = DoneablePodPreset.class;
  }

  public PodPresetOperationsImpl newInstance(OperationContext context) {
    return new PodPresetOperationsImpl(context);
  }
}
