
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.DoneableEvent;

import java.util.Map;
import java.util.TreeMap;


public class EventOperationsImpl extends HasMetadataOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> {

  public EventOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public EventOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
  }

  public EventOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("events"));
    this.type = Event.class;
    this.listType = EventList.class;
    this.doneableType = DoneableEvent.class;
  }

  public EventOperationsImpl newInstance(OperationContext context) {
    return new EventOperationsImpl(context);
  }
}
