/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.utils.ResourceCompare;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResourceCompareTest {
    private Pod pod;
    private Service service;
    private KubernetesList kubeList;

    @BeforeEach
    public void setup() {
        this.pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "value"))).and()).build();
        this.service = ((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).withNamespace("test")).and()).build();
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).build();
        this.kubeList = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
    }

    @Test
    public void testResourceCompareEqualsTrue() throws Exception {
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)this.kubeList), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResourceCompareEqualsFalse() throws Exception {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).endSpec()).build();
        KubernetesList kubeList2 = ((KubernetesListBuilder)new KubernetesListBuilder(this.kubeList).withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)kubeList2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testPodResourceCompareEqualsFalseNoLabels() throws Exception {
        Pod podNoLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podNoLabels), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testPodResourceCompareEqualsTrueMatchingLabels() throws Exception {
        Pod podWithLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "value"))).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podWithLabels), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testPodResourceCompareEqualsFalseDifferentLabels() throws Exception {
        Pod podWithLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "another value"))).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podWithLabels), (Matcher)CoreMatchers.is((Object)false));
    }
}

