/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtilsTest {
    @Test
    public void existingSysPropShouldReturnValue() {
        System.setProperty("something", "value");
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"something"));
        System.getProperties().remove("something");
    }

    @Test
    public void missingSysPropAndEnvVarShouldReturnNull() {
        Assertions.assertNull((Object)Utils.getSystemPropertyOrEnvVar((String)"doesn't exist"));
    }

    @Test
    public void existingEnvVarShouldReturnValue() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"ENV_VAR_EXISTS"));
    }

    @Test
    public void existingEnvVarShouldReturnValueFromConvertedSysPropName() {
        Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists"));
    }

    @Test
    public void existingEnvVarShouldReturnBooleanValueFromConvertedSysPropName() {
        Assertions.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists.boolean", (Boolean)false));
    }

    @Test
    public void missingEnvVarShouldReturnDefaultValue() {
        Assertions.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"DONT_EXIST", (Boolean)true));
    }
}

