/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorListenerTest {
    private static boolean addNotificationReceived;
    private static boolean updateNotificationReceived;
    private static boolean deleteNotificationReceived;

    @Test
    public void testNotificationHandling() throws InterruptedException {
        final Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo")).withNamespace("default")).endMetadata()).build();
        ProcessorListener listener = new ProcessorListener((ResourceEventHandler)new ResourceEventHandler<Pod>(){

            public void onAdd(Pod obj) {
                Assert.assertEquals((Object)pod, (Object)obj);
                addNotificationReceived = true;
            }

            public void onUpdate(Pod oldObj, Pod newObj) {
                Assert.assertEquals((Object)pod, (Object)newObj);
                updateNotificationReceived = true;
            }

            public void onDelete(Pod obj, boolean deletedFinalStateUnknown) {
                Assert.assertEquals((Object)pod, (Object)obj);
                deleteNotificationReceived = true;
            }
        }, 0L);
        listener.add((ProcessorListener.Notification)new ProcessorListener.AddNotification((Object)pod));
        listener.add((ProcessorListener.Notification)new ProcessorListener.UpdateNotification(null, (Object)pod));
        listener.add((ProcessorListener.Notification)new ProcessorListener.DeleteNotification((Object)pod));
        Thread listenerThread = new Thread(() -> ((ProcessorListener)listener).run());
        listenerThread.setDaemon(true);
        listenerThread.start();
        Thread.sleep(1000L);
        TestCase.assertTrue((boolean)addNotificationReceived);
        TestCase.assertTrue((boolean)updateNotificationReceived);
        TestCase.assertTrue((boolean)deleteNotificationReceived);
    }
}

