/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CacheTest {
    private static Cache cache = new Cache("mock", CacheTest::mockIndexFunction, CacheTest::mockKeyFunction);

    @Test
    public void testCacheIndex() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).endMetadata()).build();
        cache.add((Object)testPodObj);
        cache.replace(Arrays.asList(testPodObj), "0");
        String index = CacheTest.mockIndexFunction(testPodObj).get(0);
        String key = CacheTest.mockKeyFunction(testPodObj);
        List indexedObjectList = cache.byIndex("mock", index);
        Assert.assertEquals((Object)testPodObj, indexedObjectList.get(0));
        indexedObjectList = cache.index("mock", (Object)testPodObj);
        Assert.assertEquals((Object)testPodObj, indexedObjectList.get(0));
        List allExistingKeys = cache.listKeys();
        Assert.assertEquals((long)1L, (long)allExistingKeys.size());
        Assert.assertEquals((Object)key, allExistingKeys.get(0));
    }

    @Test
    public void testCacheStore() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod2")).endMetadata()).build();
        String index = CacheTest.mockIndexFunction(testPodObj).get(0);
        cache.replace(Arrays.asList(testPodObj), "0");
        cache.delete((Object)testPodObj);
        List indexedObjectList = cache.byIndex("mock", index);
        Assert.assertEquals((long)0L, (long)indexedObjectList.size());
        cache.add((Object)testPodObj);
        String newClusterName = "test_cluster";
        testPodObj.getMetadata().setClusterName(newClusterName);
        cache.update((Object)testPodObj);
        Assert.assertEquals((long)1L, (long)cache.list().size());
        Assert.assertEquals((Object)newClusterName, (Object)testPodObj.getMetadata().getClusterName());
    }

    @Test
    public void testDefaultNamespaceIndex() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod3")).withNamespace("default")).endMetadata()).build();
        cache.add((Object)testPodObj);
        List indices = Cache.metaNamespaceIndexFunc((Object)testPodObj);
        Assert.assertEquals((Object)testPodObj.getMetadata().getNamespace(), indices.get(0));
    }

    @Test
    public void testDefaultNamespaceKey() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod4")).withNamespace("default")).endMetadata()).build();
        cache.add((Object)testPodObj);
        Assert.assertEquals((Object)"default/test-pod4", (Object)Cache.metaNamespaceKeyFunc((Object)testPodObj));
    }

    private static List<String> mockIndexFunction(Object obj) {
        if (obj == null) {
            return Arrays.asList("null");
        }
        return Arrays.asList(obj.getClass().getName());
    }

    private static String mockKeyFunction(Object obj) {
        if (obj == null) {
            return "null";
        }
        return String.valueOf(System.identityHashCode(obj));
    }
}

