/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class BaseOperationTest {
    @Test
    public void testSimpleFieldQueryParamConcatenation() {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("yesKey1", "yesValue1");
        fieldsMap.put("yesKey2", "yesValue2");
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        ((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withFields(fieldsMap).withField("yesKey2", "overrideValue2")).withoutField("noKey1", "noValue1")).withoutField("noKey2", "noValue2");
        String fieldQueryParam = operation.getFieldQueryParam();
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey1=yesValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey2=overrideValue2"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey1!=noValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey2!=noValue2"));
    }

    @Test
    public void testSkippingFieldNotMatchingNullValues() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        ((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withField("key1", "value1").withoutField("key2", "value2")).withoutField("key2", null)).withoutField("key2", "")).withoutField("key2", "value3")).withoutField("key10", "value11")).withoutField("key10", "");
        MatcherAssert.assertThat((Object)operation.getFieldQueryParam(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"key1=value1,key2!=value2,key2!=value3,key10!=value11")));
    }
}

