package io.fabric8.kubernetes.client.extended.run;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface RunConfigFluent<A extends RunConfigFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Boolean hasImagePullPolicy();
    public A withNewImagePullPolicy(String arg1);
    public A withNewImagePullPolicy(StringBuilder arg1);
    public A withNewImagePullPolicy(StringBuffer arg1);
    public String getCommand();
    public A withCommand(String command);
    public Boolean hasCommand();
    public A withNewCommand(String arg1);
    public A withNewCommand(StringBuilder arg1);
    public A withNewCommand(StringBuffer arg1);
    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(String arg1);
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(StringBuffer arg1);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    public A withNewRestartPolicy(String arg1);
    public A withNewRestartPolicy(StringBuilder arg1);
    public A withNewRestartPolicy(StringBuffer arg1);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(String arg1);
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToEnv(String key,String value);
    public A addToEnv(Map<String,String> map);
    public A removeFromEnv(String key);
    public A removeFromEnv(Map<String,String> map);
    public Map<String,String> getEnv();
    public A withEnv(Map<String,String> env);
    public Boolean hasEnv();
    public A addToLimits(String key,Quantity value);
    public A addToLimits(Map<String,Quantity> map);
    public A removeFromLimits(String key);
    public A removeFromLimits(Map<String,Quantity> map);
    public Map<String,Quantity> getLimits();
    public A withLimits(Map<String,Quantity> limits);
    public Boolean hasLimits();
    public A addToRequests(String key,Quantity value);
    public A addToRequests(Map<String,Quantity> map);
    public A removeFromRequests(String key);
    public A removeFromRequests(Map<String,Quantity> map);
    public Map<String,Quantity> getRequests();
    public A withRequests(Map<String,Quantity> requests);
    public Boolean hasRequests();
    public int getPort();
    public A withPort(int port);
    public Boolean hasPort();
}
