/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CustomResourceOperationsImplTest {
    private final CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("custom.name")).endMetadata()).withNewSpec().withGroup("custom.group")).withVersion("v1alpha1")).withNewNames().withKind("MyCustomResource")).withListKind("MyCustomResourceList")).withPlural("mycustomresources")).withSingular("mycustomresource")).endNames()).endSpec()).build();

    @Test
    public void shouldRegisterWithKubernetesDeserializer() throws IOException {
        this.assertForContext(new CustomResourceOperationContext().withCrd(this.crd).withType(MyCustomResource.class).withListType(MyCustomResourceList.class));
    }

    @Test
    void itFallsBackOnTypeKindIfNoKindSpecifiedInContext() throws IOException {
        this.assertForContext(new CustomResourceOperationContext().withCrdContext(new CustomResourceDefinitionContext.Builder().withGroup(this.crd.getSpec().getGroup()).withVersion(this.crd.getSpec().getVersion()).withScope(this.crd.getSpec().getScope()).withName(this.crd.getMetadata().getName()).withPlural(this.crd.getSpec().getNames().getPlural()).build()).withType(MyCustomResource.class).withListType(MyCustomResourceList.class));
    }

    private void assertForContext(CustomResourceOperationContext context) throws IOException {
        new CustomResourceOperationsImpl(context);
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createParser("{\n    \"apiVersion\": \"custom.group/v1alpha1\",\n    \"kind\": \"MyCustomResource\"\n}");
        KubernetesDeserializer deserializer = new KubernetesDeserializer();
        KubernetesResource resource = deserializer.deserialize(parser, null);
        Assert.assertThat((Object)resource, (Matcher)IsInstanceOf.instanceOf(MyCustomResource.class));
        Assert.assertEquals((Object)"custom.group/v1alpha1", (Object)((MyCustomResource)resource).getApiVersion());
    }

    public static class MyCustomResourceList
    extends CustomResourceList<MyCustomResource> {
    }

    public static class MyCustomResource
    extends CustomResource {
    }
}

