/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class KubernetesResourceUtilTest {
    private ConfigMap configMap1;

    @BeforeEach
    public void createTestResource() {
        this.configMap1 = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("configmap1")).withNamespace("ns1")).withAnnotations(Collections.singletonMap("foo", "bar"))).withLabels(Collections.singletonMap("foo-label", "bar-label"))).endMetadata()).addToData("one", "1")).build();
    }

    @Test
    public void testNullSafeOperationsForName() {
        String resourceName = KubernetesResourceUtil.getName((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)resourceName);
        Assertions.assertEquals((Object)"configmap1", (Object)resourceName);
    }

    @Test
    public void testNullSafeOperationsForNamespace() {
        String namespace = KubernetesResourceUtil.getNamespace((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)namespace);
        Assertions.assertEquals((Object)"ns1", (Object)namespace);
        Assertions.assertEquals((Object)"ns1/configmap1", (Object)KubernetesResourceUtil.getQualifiedName((HasMetadata)this.configMap1));
    }

    @Test
    public void testNullSafeOperationsForLabels() {
        Map labels = KubernetesResourceUtil.getOrCreateLabels((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)labels);
        Assertions.assertEquals(Collections.singletonMap("foo-label", "bar-label"), (Object)labels);
    }

    @Test
    public void testNullSafeOperationsForAnnotations() {
        Map annos = KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)annos);
        Assertions.assertEquals(Collections.singletonMap("foo", "bar"), (Object)annos);
    }

    @Test
    public void testNames() {
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.getName((HasMetadata)this.configMap1)));
        Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidName((String)"test.invalid.name"));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation((Map)KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1)));
        Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation(Collections.singletonMap("NoUppercaseOrSpecialCharsLike=Equals", "bar")));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"test.invalid.name")));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"90notcool-n@me")));
    }

    @Test
    void testSortEventListBasedOnTimestamp() {
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event2")).endMetadata()).withLastTimestamp("2020-06-12T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event1")).endMetadata()).withLastTimestamp("2020-06-10T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event3")).endMetadata()).withLastTimestamp("2020-06-13T06:45:16Z")).build());
        KubernetesResourceUtil.sortEventListBasedOnTimestamp(eventList);
        Assertions.assertEquals((Object)"event3", (Object)((Event)eventList.get(0)).getMetadata().getName());
        Assertions.assertEquals((Object)"event2", (Object)((Event)eventList.get(1)).getMetadata().getName());
        Assertions.assertEquals((Object)"event1", (Object)((Event)eventList.get(2)).getMetadata().getName());
    }

    @Test
    @DisplayName(value="Should be able to get resource version")
    void testGetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        String resourceVersion = KubernetesResourceUtil.getResourceVersion((HasMetadata)pod);
        Assertions.assertEquals((Object)"1001", (Object)resourceVersion);
    }

    @Test
    @DisplayName(value="Should be able to update resource version")
    void testSetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        KubernetesResourceUtil.setResourceVersion((HasMetadata)pod, (String)"1002");
        Assertions.assertEquals((Object)"1002", (Object)pod.getMetadata().getResourceVersion());
    }
}

