/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.utils.SerializationTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class DefaultKubernetesClientTest {
    private DefaultKubernetesClient defaultKubernetesClient;

    @BeforeEach
    public void setUp() {
        this.defaultKubernetesClient = new DefaultKubernetesClient();
    }

    @AfterEach
    public void tearDown() {
        this.defaultKubernetesClient.close();
        this.defaultKubernetesClient = null;
    }

    @Test
    public void testInitClientWithCustomHeaderConfiguration() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config configWithCustomerHeaders = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        DefaultKubernetesClient customHeaderConfigClient = new DefaultKubernetesClient(configWithCustomerHeaders);
        Assert.assertEquals((long)1L, (long)customHeaderConfigClient.getHttpClient().networkInterceptors().size());
    }

    @Test
    public void testInitClientWithDefaultConfiguration() {
        Config defaultEmptyConfig = new ConfigBuilder().build();
        DefaultKubernetesClient defaultConfigClient = new DefaultKubernetesClient(defaultEmptyConfig);
        Assert.assertTrue((boolean)defaultConfigClient.getHttpClient().networkInterceptors().isEmpty());
    }

    @Test
    @DisplayName(value="load, InputStream containing List with windows like line-ends (CRLF), all list items should be available")
    public void loadWithWindowsLineSeparatorsString() throws Exception {
        List<String> fileLines = Files.readAllLines(new File(SerializationTest.class.getResource("/test-list.yml").getFile()).toPath(), StandardCharsets.UTF_8);
        String crlfFile = String.join((CharSequence)" \r\n", fileLines);
        List result = (List)new DefaultKubernetesClient().load((InputStream)new ByteArrayInputStream(crlfFile.getBytes(StandardCharsets.UTF_8))).get();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Service));
        Assert.assertTrue((boolean)(result.get(1) instanceof Deployment));
    }
}

