
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.scheduling.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.scheduling.DoneablePriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClassList;
import io.fabric8.kubernetes.api.model.scheduling.DoneablePriorityClass;

import java.util.Map;
import java.util.TreeMap;


public class PriorityClassOperationsImpl extends HasMetadataOperation<PriorityClass, PriorityClassList, DoneablePriorityClass, Resource<PriorityClass, DoneablePriorityClass>> {

  public PriorityClassOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public PriorityClassOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PriorityClassOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("scheduling.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("priorityclasses"));
    this.type = PriorityClass.class;
    this.listType = PriorityClassList.class;
    this.doneableType = DoneablePriorityClass.class;
  }

  public PriorityClassOperationsImpl newInstance(OperationContext context) {
    return new PriorityClassOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
