
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ReplicationControllerHandler implements ResourceHandler<ReplicationController, ReplicationControllerBuilder> {

  @Override
  public String getKind() {
    return ReplicationController.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ReplicationController create(OkHttpClient client, Config config, String namespace, ReplicationController item) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ReplicationController replace(OkHttpClient client, Config config, String namespace, ReplicationController item) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ReplicationController reload(OkHttpClient client, Config config, String namespace, ReplicationController item) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ReplicationControllerBuilder edit(ReplicationController item) {
    return new ReplicationControllerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ReplicationController item) {
    return new ReplicationControllerOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicationController item, Watcher<ReplicationController> watcher) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicationController item, String resourceVersion, Watcher<ReplicationController> watcher) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicationController item, ListOptions options, Watcher<ReplicationController> watcher) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ReplicationController waitUntilReady(OkHttpClient client, Config config, String namespace, ReplicationController item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ReplicationController waitUntilCondition(OkHttpClient client, Config config, String namespace, ReplicationController item, Predicate<ReplicationController> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
