/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class SerializationTest {
    @Test
    void unmarshalCRDWithSchema() throws Exception {
        String input = this.readYamlToString("/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        JSONSchemaProps spec = (JSONSchemaProps)crd.getSpec().getValidation().getOpenAPIV3Schema().getProperties().get("spec");
        Assert.assertEquals((long)spec.getRequired().size(), (long)3L);
        Assert.assertEquals(spec.getRequired().get(0), (Object)"builderName");
        Assert.assertEquals(spec.getRequired().get(1), (Object)"edges");
        Assert.assertEquals(spec.getRequired().get(2), (Object)"dimensions");
        Map properties = spec.getProperties();
        Assert.assertNotNull(properties.get("builderName"));
        Assert.assertEquals((Object)((JSONSchemaProps)properties.get("builderName")).getExample(), (Object)new TextNode("builder-example"));
        Assert.assertEquals((Object)((JSONSchemaProps)properties.get("hollow")).getDefault(), (Object)BooleanNode.FALSE);
        Assert.assertNotNull(properties.get("dimensions"));
        Assert.assertNotNull(((JSONSchemaProps)properties.get("dimensions")).getProperties().get("x"));
        Assert.assertEquals((Object)((JSONSchemaProps)((JSONSchemaProps)properties.get("dimensions")).getProperties().get("x")).getDefault(), (Object)new IntNode(10));
        String output = Serialization.asYaml((Object)crd);
        Assert.assertEquals((Object)input.trim(), (Object)output.trim());
    }

    @Test
    @DisplayName(value="unmarshal, String containing List with windows like line-ends (CRLF), all list items should be available")
    void unmarshalListWithWindowsLineSeparatorsString() throws Exception {
        String crlfFile = this.readYamlToString("/test-list.yml");
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)crlfFile, KubernetesResource.class);
        Assert.assertTrue((boolean)(result instanceof KubernetesList));
        KubernetesList kubernetesList = (KubernetesList)result;
        Assert.assertEquals((long)2L, (long)kubernetesList.getItems().size());
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(0) instanceof Service));
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(1) instanceof Deployment));
    }

    private String readYamlToString(String path) throws IOException {
        return Files.readAllLines(new File(SerializationTest.class.getResource(path).getFile()).toPath(), StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining("\n"));
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with windows line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with windows line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n");
        Assert.assertFalse((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with linux line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with linux line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n");
        Assert.assertFalse((boolean)result);
    }
}

