/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.DoneableLease;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class LeaseLockTest {
    private DefaultKubernetesClient kc;
    private MixedOperation<Lease, LeaseList, DoneableLease, Resource<Lease, DoneableLease>> leases;
    private DoneableLease doneableLease;
    private LeaseFluent.MetadataNested<DoneableLease> metadata;
    private LeaseFluent.SpecNested<DoneableLease> spec;

    LeaseLockTest() {
    }

    @BeforeEach
    void setUp() {
        this.kc = (DefaultKubernetesClient)Mockito.mock(DefaultKubernetesClient.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.leases = (MixedOperation)Mockito.mock(MixedOperation.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.doneableLease = (DoneableLease)Mockito.mock(DoneableLease.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.metadata = (LeaseFluent.MetadataNested)Mockito.mock(LeaseFluent.MetadataNested.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.spec = (LeaseFluent.SpecNested)Mockito.mock(LeaseFluent.SpecNested.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.kc.inNamespace(ArgumentMatchers.anyString()).leases()).thenReturn(this.leases);
        Mockito.when((Object)((DoneableLease)((Resource)this.leases.withName(ArgumentMatchers.anyString())).createNew())).thenReturn((Object)this.doneableLease);
        Mockito.when((Object)this.doneableLease.withNewMetadata()).thenReturn(this.metadata);
        Mockito.when((Object)this.doneableLease.withNewSpec()).thenReturn(this.spec);
    }

    @Test
    void missingNamespaceShouldThrowException() {
        Executable newInstance = () -> new LeaseLock(null, "name", "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingNameShouldThrowException() {
        Executable newInstance = () -> new LeaseLock("namespace", null, "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingIdentityShouldThrowException() {
        Executable newInstance = () -> new LeaseLock("namespace", "name", null);
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void getWithExistingLeaseShouldReturnLeaderElectionRecord() {
        Lease lease = ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)new LeaseBuilder().withNewSpec().withHolderIdentity("1337")).withLeaseDurationSeconds(Integer.valueOf(15))).withAcquireTime(ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")))).withRenewTime(ZonedDateTime.of(2015, 10, 21, 7, 28, 0, 0, ZoneId.of("UTC")))).withLeaseTransitions(Integer.valueOf(0))).endSpec()).build();
        Mockito.when((Object)((Lease)((Resource)this.leases.withName((String)ArgumentMatchers.eq((Object)"name"))).get())).thenReturn((Object)lease);
        lease.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withResourceVersion("313373")).build());
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        LeaderElectionRecord result = lock.get((Namespaceable)this.kc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"313373", (Object)result.getVersion());
        Assert.assertEquals((Object)"1337", (Object)result.getHolderIdentity());
        Assert.assertEquals((long)15L, (long)result.getLeaseDuration().getSeconds());
        Assert.assertEquals((Object)ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")), (Object)result.getAcquireTime());
    }

    @Test
    void createWithValidLeaderElectionRecordShouldSendPostRequest() throws Exception {
        Mockito.when((Object)((DoneableLease)((LeaseFluent.MetadataNested)((LeaseFluent.MetadataNested)this.metadata.withNamespace("namespace")).withName("name")).endMetadata())).thenReturn((Object)this.doneableLease);
        Mockito.when((Object)((DoneableLease)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)this.spec.withHolderIdentity((String)ArgumentMatchers.eq((Object)"1"))).withLeaseDurationSeconds(Integer.valueOf(ArgumentMatchers.eq((int)1)))).withAcquireTime((ZonedDateTime)ArgumentMatchers.any())).withRenewTime((ZonedDateTime)ArgumentMatchers.any())).withLeaseTransitions(Integer.valueOf(ArgumentMatchers.anyInt()))).endSpec())).thenReturn((Object)this.doneableLease);
        LeaderElectionRecord record = new LeaderElectionRecord("1", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        lock.create((Namespaceable)this.kc, record);
        ((DoneableLease)Mockito.verify((Object)this.doneableLease, (VerificationMode)Mockito.times((int)1))).done();
    }

    @Test
    void updateWithValidLeaderElectionRecordShouldSendPutRequest() throws Exception {
        Resource leaseResource = (Resource)this.leases.withName("name");
        Replaceable replaceable = (Replaceable)Mockito.mock(Replaceable.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((Replaceable)leaseResource.lockResourceVersion((String)ArgumentMatchers.any()))).thenReturn((Object)replaceable);
        Lease leaseInTheCluster = new Lease();
        leaseInTheCluster.setSpec(new LeaseSpec());
        Mockito.when((Object)((Lease)leaseResource.get())).thenReturn((Object)leaseInTheCluster);
        LeaderElectionRecord record = new LeaderElectionRecord("1337", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        record.setVersion((Serializable)((Object)"313373"));
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        lock.update((Namespaceable)this.kc, record);
        ((Replaceable)Mockito.verify((Object)replaceable, (VerificationMode)Mockito.times((int)1))).replace((Object)((Lease)ArgumentMatchers.eq((Object)leaseInTheCluster)));
        Assert.assertEquals((Object)"1337", (Object)leaseInTheCluster.getSpec().getHolderIdentity());
    }

    @Test
    void identityShouldReturnProvidedIdentity() {
        LeaseLock leaseLock = new LeaseLock("namespace", "name", "1337");
        String identity = leaseLock.identity();
        Assert.assertEquals((Object)"1337", (Object)identity);
    }

    @Test
    void describeShouldReturnAnIdentifiableDescription() {
        LeaseLock leaseLock = new LeaseLock("namespace", "name", "1337");
        String description = leaseLock.describe();
        Assert.assertEquals((Object)"LeaseLock: namespace - name (1337)", (Object)description);
    }
}

