/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BaseOperationTest {
    @Test
    public void testSimpleFieldQueryParamConcatenation() {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("yesKey1", "yesValue1");
        fieldsMap.put("yesKey2", "yesValue2");
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        ((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withFields(fieldsMap).withField("yesKey2", "overrideValue2")).withoutField("noKey1", "noValue1")).withoutField("noKey2", "noValue2");
        String fieldQueryParam = operation.getFieldQueryParam();
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey1=yesValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey2=overrideValue2"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey1!=noValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey2!=noValue2"));
    }

    @Test
    public void testSkippingFieldNotMatchingNullValues() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        ((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withField("key1", "value1").withoutField("key2", "value2")).withoutField("key2", null)).withoutField("key2", "")).withoutField("key2", "value3")).withoutField("key10", "value11")).withoutField("key10", "");
        MatcherAssert.assertThat((Object)operation.getFieldQueryParam(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"key1=value1,key2!=value2,key2!=value3,key10!=value11")));
    }

    @Test
    public void testDefaultGracePeriod() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        MatcherAssert.assertThat((Object)operation.getGracePeriodSeconds(), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    public void testChainingGracePeriodAndPropagationPolicy() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        EditReplacePatchDeletable operationWithPropagationPolicy = operation.withPropagationPolicy(DeletionPropagation.FOREGROUND);
        MatcherAssert.assertThat((Object)operationWithPropagationPolicy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertNotNull((Object)operationWithPropagationPolicy.withGracePeriod(10L));
    }

    @Test
    public void testListOptions() throws MalformedURLException {
        URL url = new URL("https://172.17.0.2:8443/api/v1/namespaces/default/pods");
        BaseOperation operation = new BaseOperation(new OperationContext());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&fieldSelector=status.phase%3DRunning"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&fieldSelector=status.phase%3DRunning"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10&allowWatchBookmarks=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10&allowWatchBookmarks=true&watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).withWatch(Boolean.valueOf(true))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?resourceVersion=210448"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).toString());
    }
}

