/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.client.handlers.core.v1.ServiceHandler;
import java.util.LinkedHashMap;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceHandlerTest {
    @Test
    public void testKeyString() {
        ResourceHandler.Key k = new ResourceHandler.Key("deployment", "apps/v1");
        Assertions.assertEquals((Object)"Key[kind=`deployment`, apiVersion=`apps/v1`]", (Object)k.toString());
    }

    @Test
    public void testKeyHashCode() {
        ResourceHandler.Key k1 = new ResourceHandler.Key("deployment", "apps/v1");
        ResourceHandler.Key k2 = new ResourceHandler.Key("deployment", "apps/v1");
        Assertions.assertEquals((int)k1.hashCode(), (int)k2.hashCode());
    }

    @Test
    public void testKeyEquals() {
        ResourceHandler.Key k1 = new ResourceHandler.Key("deployment", "apps/v1");
        ResourceHandler.Key k2 = new ResourceHandler.Key("deployment", "apps/v1");
        Assertions.assertEquals((Object)k1, (Object)k2);
        k1 = new ResourceHandler.Key("deployment", "apps/v1");
        k2 = new ResourceHandler.Key("other", "apps/v1");
        Assertions.assertNotEquals((Object)k1, (Object)k2);
        k1 = new ResourceHandler.Key("deployment", "apps/v1");
        k2 = new ResourceHandler.Key("deployment", "other");
        Assertions.assertNotEquals((Object)k1, (Object)k2);
    }

    @Test
    public void testAllRegisteredResourceHandlersKeysDiffer() {
        LinkedHashMap keys = new LinkedHashMap();
        Consumer<ResourceHandler> check = h -> {
            ResourceHandler conflict = keys.put(new ResourceHandler.Key(h.getKind(), h.getApiVersion()), h);
            Assertions.assertTrue((conflict == null || conflict.getClass().equals(h.getClass()) ? 1 : 0) != 0, (String)("Identical keys for different handlers " + h + " and " + conflict));
        };
        ServiceLoader.load(ResourceHandler.class).forEach(check);
        check.accept((ResourceHandler)new KubernetesListHandler());
        check.accept((ResourceHandler)new ServiceHandler());
    }
}

