/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.ReplaceValueStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER;
    private static final String DOCUMENT_DELIMITER = "---";

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) throws KubernetesClientException {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) throws KubernetesClientException {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is) throws KubernetesClientException {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, Map<String, String> parameters) {
        String specFile = Serialization.readSpecFileFromInputStream(is);
        if (Serialization.containsMultipleDocuments(specFile)) {
            return (T)Serialization.getKubernetesResourceList(parameters, specFile);
        }
        return Serialization.unmarshal((InputStream)new ByteArrayInputStream(specFile.getBytes()), JSON_MAPPER, parameters);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        try (InputStream wrapped = parameters != null && !parameters.isEmpty() ? ReplaceValueStream.replaceValues(is, parameters) : is;){
            Object object;
            try (BufferedInputStream bis = new BufferedInputStream(wrapped);){
                int intch;
                bis.mark(-1);
                while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
                }
                bis.reset();
                if (intch != 123) {
                    mapper = YAML_MAPPER;
                }
                object = mapper.readerFor(KubernetesResource.class).readValue((InputStream)bis);
            }
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> type) {
        return Serialization.unmarshal(str, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            }, parameters);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }, parameters);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type, Map<String, String> parameters) {
        try (InputStream wrapped = parameters != null && !parameters.isEmpty() ? ReplaceValueStream.replaceValues(is, parameters) : is;){
            Object object;
            try (BufferedInputStream bis = new BufferedInputStream(wrapped);){
                int intch;
                bis.mark(-1);
                while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
                }
                bis.reset();
                ObjectMapper mapper = JSON_MAPPER;
                if (intch != 123) {
                    mapper = YAML_MAPPER;
                }
                object = mapper.readValue((InputStream)bis, type);
            }
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static List<KubernetesResource> getKubernetesResourceList(Map<String, String> parameters, String specFile) {
        return Serialization.splitSpecFile(specFile).stream().filter(Serialization::validate).map(document -> (KubernetesResource)Serialization.unmarshal((InputStream)new ByteArrayInputStream(document.getBytes()), parameters)).collect(Collectors.toList());
    }

    static boolean containsMultipleDocuments(String specFile) {
        long validDocumentCount = Serialization.splitSpecFile(specFile).stream().filter(Serialization::validate).count();
        return validDocumentCount > 1L;
    }

    private static List<String> splitSpecFile(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        StringBuilder documentBuilder = new StringBuilder();
        for (String line : aSpecFile.split("\r?\n")) {
            if (line.startsWith(DOCUMENT_DELIMITER)) {
                documents.add(documentBuilder.toString());
                documentBuilder.setLength(0);
                continue;
            }
            documentBuilder.append(line).append(System.lineSeparator());
        }
        if (documentBuilder.length() > 0) {
            documents.add(documentBuilder.toString());
        }
        return documents;
    }

    private static boolean validate(String document) {
        Matcher keyValueMatcher = Pattern.compile("(\\S+):\\s(\\S*)(?:\\b(?!:)|$)").matcher(document);
        return !document.isEmpty() && keyValueMatcher.find();
    }

    private static String readSpecFileFromInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read InputStream." + e);
        }
    }

    static {
        JSON_MAPPER.registerModule((Module)new JavaTimeModule());
        YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    }
}

