
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                                                

package io.fabric8.kubernetes.client.handlers.events.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.events.v1beta1.EventOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.events.Event;
import io.fabric8.kubernetes.api.model.events.EventBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EventHandler implements ResourceHandler<Event, EventBuilder> {

  @Override
  public String getKind() {
    return Event.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "events.k8s.io/v1beta1";
      }

  @Override
  public Event create(OkHttpClient client, Config config, String namespace, Event item) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Event replace(OkHttpClient client, Config config, String namespace, Event item) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Event reload(OkHttpClient client, Config config, String namespace, Event item) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EventBuilder edit(Event item) {
    return new EventBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Event item) {
    return new EventOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Event item, Watcher<Event> watcher) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Event item, String resourceVersion, Watcher<Event> watcher) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Event waitUntilReady(OkHttpClient client, Config config, String namespace, Event item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Event waitUntilCondition(OkHttpClient client, Config config, String namespace, Event item, Predicate<Event> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
