
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                                          

package io.fabric8.kubernetes.client.handlers.apps.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ControllerRevisionOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ControllerRevisionHandler implements ResourceHandler<ControllerRevision, ControllerRevisionBuilder> {

  @Override
  public String getKind() {
    return ControllerRevision.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apps/v1";
      }

  @Override
  public ControllerRevision create(OkHttpClient client, Config config, String namespace, ControllerRevision item) {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ControllerRevision replace(OkHttpClient client, Config config, String namespace, ControllerRevision item) {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ControllerRevision reload(OkHttpClient client, Config config, String namespace, ControllerRevision item) {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ControllerRevisionBuilder edit(ControllerRevision item) {
    return new ControllerRevisionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ControllerRevision item) {
    return new ControllerRevisionOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ControllerRevision item, Watcher<ControllerRevision> watcher) {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ControllerRevision item, String resourceVersion, Watcher<ControllerRevision> watcher) {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public ControllerRevision waitUntilReady(OkHttpClient client, Config config, String namespace, ControllerRevision item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ControllerRevision waitUntilCondition(OkHttpClient client, Config config, String namespace, ControllerRevision item, Predicate<ControllerRevision> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ControllerRevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
