
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                                          

package io.fabric8.kubernetes.client.dsl.internal.discovery.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.discovery.DoneableEndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.EndpointSliceList;
import io.fabric8.kubernetes.api.model.discovery.DoneableEndpointSlice;

import java.util.Map;
import java.util.TreeMap;


public class EndpointSliceOperationsImpl extends HasMetadataOperation<EndpointSlice, EndpointSliceList, DoneableEndpointSlice, Resource<EndpointSlice, DoneableEndpointSlice>> {

  public EndpointSliceOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public EndpointSliceOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public EndpointSliceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("discovery")
    .withApiGroupVersion("v1beta1")
    .withPlural("endpointslices"));
    this.type = EndpointSlice.class;
    this.listType = EndpointSliceList.class;
    this.doneableType = DoneableEndpointSlice.class;
  }

  public EndpointSliceOperationsImpl newInstance(OperationContext context) {
    return new EndpointSliceOperationsImpl(context);
  }
}
