/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DoneableKubernetesList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.KubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.KubernetesListOperation;
import io.fabric8.kubernetes.client.dsl.Loadable;
import io.fabric8.kubernetes.client.dsl.RecreateFromServerGettable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.OkHttpClient;

public class KubernetesListOperationsImpl
extends OperationSupport
implements KubernetesListOperation,
KubernetesListMixedOperation,
Loadable<RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList>>,
RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> {
    private final KubernetesList item;
    private final Boolean fromServer;
    private final Boolean deletingExisting;

    public KubernetesListOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, namespace, null, null, false, false, null, null);
    }

    public KubernetesListOperationsImpl(OkHttpClient client, Config config, String namespace, String name, Boolean cascading, Boolean fromServer, Boolean deletingExisting, KubernetesList item, String resourceVersion) {
        super(client, config, null, null, null, namespace, null);
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.item = item;
    }

    @Override
    public KubernetesListNonNamespaceOperation inNamespace(String namespace) {
        return new KubernetesListOperationsImpl(this.client, this.config, namespace);
    }

    public KubernetesList create(KubernetesList ... items) {
        ArrayList<HasMetadata> createdItems = new ArrayList<HasMetadata>();
        if (items.length == 0) {
            items = new KubernetesList[]{this.get()};
        }
        for (KubernetesList i : items) {
            for (HasMetadata r : i.getItems()) {
                HasMetadata created = this.create(r);
                createdItems.add(created);
            }
        }
        KubernetesList createdList = new KubernetesList();
        createdList.setItems(createdItems);
        return createdList;
    }

    @Override
    public DoneableKubernetesList createNew() {
        return new DoneableKubernetesList(item -> {
            try {
                return this.create((KubernetesList)item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(String path) {
        return this.load(new File(path));
    }

    @Override
    public RecreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(InputStream is) {
        return new KubernetesListOperationsImpl(this.client, this.config, this.namespace, null, false, this.fromServer, this.deletingExisting, KubernetesListOperationsImpl.unmarshal(is, KubernetesList.class), null);
    }

    @Override
    public KubernetesList get() {
        return this.item;
    }

    private <T extends HasMetadata, V extends VisitableBuilder<T, V>> T create(T resource) {
        ResourceHandler handler = Handlers.get(resource.getKind());
        if (handler != null) {
            return (T)((HasMetadata)handler.create(this.client, this.config, this.namespace, resource));
        }
        throw new IllegalStateException("Could not find handler");
    }

    public Boolean delete(KubernetesList ... lists) {
        return this.delete((List)Arrays.asList(lists));
    }

    @Override
    public Boolean delete(List<KubernetesList> lists) {
        for (KubernetesList list : lists) {
            for (HasMetadata item : list.getItems()) {
                ResourceHandler handler = Handlers.get(item.getKind());
                if (handler.delete(this.client, this.config, this.namespace, item).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Gettable<KubernetesList> fromServer() {
        return new KubernetesListOperationsImpl(this.client, this.config, this.namespace, null, false, true, this.deletingExisting, this.item, null);
    }

    @Override
    public Createable<KubernetesList, KubernetesList, DoneableKubernetesList> deletingExisting() {
        return new KubernetesListOperationsImpl(this.client, this.config, this.namespace, null, false, this.fromServer, true, this.item, null);
    }
}

