/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.URLUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class URLUtilsTest {
    @Test
    public void shouldJoinUrlWithoutQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        Assert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/api"));
    }

    @Test
    public void shouldJoinUrlWithQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes?key=value";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        Assert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/api?key=value"));
    }

    @Test
    public void shouldJoinNoneUrl() {
        String masterUrl = "images.openshift.io";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        Assert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"images.openshift.io/api"));
    }
}

