/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CertUtilsTest {
    private static String FABRIC8_STORE_PATH = CertUtilsTest.decodeUrl(CertUtilsTest.class.getResource("/ssl/fabric8-store").getPath());
    private static char[] FABRIC8_STORE_PASSPHRASE = "fabric8".toCharArray();
    private Properties systemProperties;

    @Before
    public void storeSystemProperties() {
        this.systemProperties = new Properties();
        this.storeSystemProperty(CertUtils.TRUST_STORE_SYSTEM_PROPERTY);
        this.storeSystemProperty(CertUtils.TRUST_STORE_PASSWORD_SYSTEM_PROPERTY);
        this.storeSystemProperty(CertUtils.KEY_STORE_SYSTEM_PROPERTY);
        this.storeSystemProperty(CertUtils.KEY_STORE_PASSWORD_SYSTEM_PROPERTY);
    }

    private void storeSystemProperty(String systemProperty) {
        String value = System.getProperty(systemProperty);
        if (Utils.isNotNullOrEmpty((String)value)) {
            this.systemProperties.put(systemProperty, value);
        }
    }

    @After
    public void resetSystemPropertiesBack() {
        System.setProperties(this.systemProperties);
    }

    @Ignore
    @Test
    public void testLoadingDodgyKubeConfig() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, InvalidKeySpecException {
        System.setProperty("kubeconfig", "/tmp/ceposta.kubeconfig");
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        Config config = client.getConfiguration();
        KeyStore ts = CertUtils.createTrustStore((String)config.getCaCertData(), null, null, (String)"changeit");
        KeyStore ks = CertUtils.createKeyStore((String)config.getClientCertData(), null, (String)config.getClientKeyData(), null, (String)"RSA", (String)"changeit", null, (String)"changeit");
    }

    @Test
    public void testLoadingMultipleCertsFromSameFile() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore ts = CertUtils.createTrustStore((InputStream)this.getMultipleCertsInputSteam(), null, (char[])"changeit".toCharArray());
        Assert.assertTrue((ts.size() >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadTrustStoreFromFileUsingConfigProperties() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore trustStore = CertUtils.createTrustStore((InputStream)this.getMultipleCertsInputSteam(), (String)FABRIC8_STORE_PATH, (char[])FABRIC8_STORE_PASSPHRASE);
        Assert.assertEquals((long)3L, (long)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    public void testLoadTrustStoreFromFileUsingSystemProperties() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        System.setProperty(CertUtils.TRUST_STORE_SYSTEM_PROPERTY, FABRIC8_STORE_PATH);
        System.setProperty(CertUtils.TRUST_STORE_PASSWORD_SYSTEM_PROPERTY, String.valueOf(FABRIC8_STORE_PASSPHRASE));
        KeyStore trustStore = CertUtils.createTrustStore((InputStream)this.getMultipleCertsInputSteam(), null, null);
        Assert.assertEquals((long)3L, (long)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    public void testLoadKeyStoreFromFileUsingConfigProperties() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        InputStream privateKey = this.getClass().getResourceAsStream("/ssl/fabric8");
        KeyStore trustStore = CertUtils.createKeyStore((InputStream)this.getMultipleCertsInputSteam(), (InputStream)privateKey, (String)"RSA", (char[])"changeit".toCharArray(), (String)FABRIC8_STORE_PATH, (char[])FABRIC8_STORE_PASSPHRASE);
        Assert.assertEquals((long)2L, (long)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    public void testLoadKeyStoreFromFileUsingSystemProperties() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        System.setProperty(CertUtils.KEY_STORE_SYSTEM_PROPERTY, FABRIC8_STORE_PATH);
        System.setProperty(CertUtils.KEY_STORE_PASSWORD_SYSTEM_PROPERTY, String.valueOf(FABRIC8_STORE_PASSPHRASE));
        String privateKeyPath = CertUtilsTest.decodeUrl(this.getClass().getResource("/ssl/fabric8").getPath());
        String multipleCertsPath = CertUtilsTest.decodeUrl(this.getClass().getResource("/ssl/multiple-certs.pem").getPath());
        KeyStore trustStore = CertUtils.createKeyStore(null, (String)multipleCertsPath, null, (String)privateKeyPath, (String)"RSA", (String)"changeit", null, null);
        Assert.assertEquals((long)2L, (long)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    private void verifyFabric8InStore(KeyStore trustStore) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        Certificate certificate = trustStore.getCertificate("fabric8-in-store");
        Assert.assertNotNull((Object)certificate);
        InputStream certificateFile = this.getClass().getResourceAsStream("/ssl/fabric8.crt");
        KeyStore storeWithCert = CertUtils.createTrustStore((InputStream)certificateFile, null, (char[])"".toCharArray());
        String certificateAlias = storeWithCert.getCertificateAlias(certificate);
        Assert.assertNotNull((Object)certificateAlias);
    }

    private InputStream getMultipleCertsInputSteam() {
        return this.getClass().getResourceAsStream("/ssl/multiple-certs.pem");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

