/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.api.model.WatchEventBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.server.mock.KubernetesServer;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchTest {
    Logger logger = LoggerFactory.getLogger(WatchTest.class);
    @Rule
    public KubernetesServer server = new KubernetesServer(false);
    static final Pod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace("test")).withName("pod1")).withResourceVersion("1")).endMetadata()).build();
    static final Status outdatedStatus = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(410))).withMessage("401: The event in requested index is outdated and cleared (the requested history has been cleared [3/1]) [2]")).build();
    static final WatchEvent outdatedEvent = ((WatchEventBuilder)new WatchEventBuilder().withStatusObject(outdatedStatus)).build();

    @Test
    public void testDeletedAndOutdated() throws InterruptedException {
        this.logger.info("testDeletedAndOutdated");
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((EventDoneable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(2000L).andEmit((Object)new WatchEvent((KubernetesResource)pod1, "DELETED"))).waitFor(2000L).andEmit((Object)outdatedEvent)).done()).once();
        final CountDownLatch deleteLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((Watchable)((ClientPodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                switch (action) {
                    case DELETED: {
                        deleteLatch.countDown();
                        break;
                    }
                    default: {
                        throw new AssertionFailedError();
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
                closeLatch.countDown();
            }
        });){
            Assert.assertTrue((boolean)deleteLatch.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)closeLatch.await(10L, TimeUnit.SECONDS));
        }
    }

    @Test(expected=KubernetesClientException.class)
    public void testHttpErrorWithOutdated() {
        this.logger.info("testHttpErrorWithOutdated");
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturn(410, (Object)outdatedEvent)).once();
        Watch watch = (Watch)((Watchable)((ClientPodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                throw new AssertionFailedError();
            }

            public void onClose(KubernetesClientException cause) {
                throw new AssertionFailedError();
            }
        });
        Throwable throwable = null;
        if (watch != null) {
            if (throwable != null) {
                try {
                    watch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                watch.close();
            }
        }
    }

    @Test
    public void testHttpErrorReconnect() throws InterruptedException {
        this.logger.info("testHttpErrorReconnect");
        String path = "/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true";
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)this.server.expect().withPath(path)).andUpgradeToWebSocket()).open(new Object[0])).done()).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath(path)).andReturn(503, (Object)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(503))).build())).times(6);
        ((TimesOrOnceable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)this.server.expect().withPath(path)).andUpgradeToWebSocket()).open(new Object[]{outdatedEvent})).done()).once();
        final CountDownLatch closeLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((Watchable)((ClientPodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                throw new AssertionFailedError();
            }

            public void onClose(KubernetesClientException cause) {
                WatchTest.this.logger.debug("onClose", (Throwable)cause);
                closeLatch.countDown();
            }
        });){
            Assert.assertTrue((boolean)closeLatch.await(3L, TimeUnit.MINUTES));
        }
    }
}

