/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Callback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamPumper
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamReader.class);
    private final InputStream in;
    private final Callback<byte[]> callback;
    private final Runnable onClose;
    private boolean keepReading = true;
    private Thread thread;

    public InputStreamPumper(InputStream in, Callback<byte[]> callback) {
        this(in, callback, null);
    }

    public InputStreamPumper(InputStream in, Callback<byte[]> callback, Runnable onClose) {
        this.in = in;
        this.callback = callback;
        this.onClose = onClose;
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while (this.keepReading && !Thread.currentThread().isInterrupted() && (length = this.in.read(buffer)) != -1) {
                byte[] actual = new byte[length];
                System.arraycopy(buffer, 0, actual, 0, length);
                this.callback.call(actual);
            }
        }
        catch (InterruptedIOException e) {
            LOGGER.debug("Interrupted while pumping stream.", (Throwable)e);
        }
        catch (IOException e) {
            if (!Thread.currentThread().isInterrupted()) {
                LOGGER.error("Error while pumping stream.", (Throwable)e);
            }
            LOGGER.debug("Interrupted while pumping stream.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.keepReading = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }
}

