/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.osgi;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetDeleteRecreateApplicable;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public ClientMixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, ClientResource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public NamespaceVisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceVisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public ClientMixedOperation<Endpoints, EndpointsList, DoneableEndpoints, ClientResource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public ClientMixedOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public ClientMixedOperation<io.fabric8.kubernetes.api.model.Service, ServiceList, DoneableService, ClientResource<io.fabric8.kubernetes.api.model.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public ClientNonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, ClientResource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public ClientMixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, ClientResource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public ClientNonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, ClientResource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public ClientMixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, ClientResource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public ClientKubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public ClientNonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, ClientResource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public ClientMixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, ClientResource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public ClientMixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, ClientResource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public ClientNonNamespaceOperation<Node, NodeList, DoneableNode, ClientResource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public ClientMixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, ClientResource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public ClientMixedOperation<Event, EventList, DoneableEvent, ClientResource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public ClientMixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public ClientMixedOperation<Secret, SecretList, DoneableSecret, ClientResource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }
}

