/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.Version;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;
import okhttp3.TlsVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_API_VERSION_SYSTEM_PROPERTY = "kubernetes.api.version";
    public static final String KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY = "kubernetes.trust.certificates";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.ca.file";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.ca.data";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.file";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.data";
    public static final String KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.file";
    public static final String KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.key.data";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY = "kubernetes.certs.client.key.algo";
    public static final String KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.passphrase";
    public static final String KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY = "kubernetes.auth.basic.username";
    public static final String KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY = "kubernetes.auth.basic.password";
    public static final String KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY = "kubernetes.auth.tryKubeConfig";
    public static final String KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY = "kubernetes.auth.tryServiceAccount";
    public static final String KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY = "kubernetes.auth.token";
    public static final String KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY = "kubernetes.watch.reconnectInterval";
    public static final String KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY = "kubernetes.watch.reconnectLimit";
    public static final String KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.connection.timeout";
    public static final String KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.request.timeout";
    public static final String KUBERNETES_ROLLING_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.rolling.timeout";
    public static final String KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.logging.interval";
    public static final String KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.scale.timeout";
    public static final String KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.websocket.timeout";
    public static final String KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.websocket.ping.interval";
    public static final String KUBERNETES_TLS_VERSIONS = "kubernetes.tls.versions";
    public static final String KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY = "kubernetes.tryNamespacePath";
    public static final String KUBERNETES_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String KUBERNETES_NAMESPACE_FILE = "kubenamespace";
    public static final String KUBERNETES_NAMESPACE_SYSTEM_PROPERTY = "kubernetes.namespace";
    public static final String KUBERNETES_KUBECONFIG_FILE = "kubeconfig";
    public static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String KUBERNETES_HTTP_PROXY = "http.proxy";
    public static final String KUBERNETES_HTTPS_PROXY = "https.proxy";
    public static final String KUBERNETES_ALL_PROXY = "all.proxy";
    public static final String KUBERNETES_NO_PROXY = "no.proxy";
    public static final String KUBERNETES_USER_AGENT = "fabric8-kubernetes-client/" + Version.clientVersion();
    public static final Long DEFAULT_ROLLING_TIMEOUT = 900000L;
    public static final Long DEFAULT_SCALE_TIMEOUT = 600000L;
    public static final int DEFAULT_LOGGING_INTERVAL = 20000;
    public static final Long DEFAULT_WEBSOCKET_TIMEOUT = 5000L;
    public static final Long DEFAULT_WEBSOCKET_PING_INTERVAL = 1000L;
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private boolean trustCerts;
    private String masterUrl = "https://kubernetes.default.svc";
    private String apiVersion = "v1";
    private String namespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo = "RSA";
    private String clientKeyPassphrase = "changeit";
    private String username;
    private String password;
    private String oauthToken;
    private int watchReconnectInterval = 1000;
    private int watchReconnectLimit = -1;
    private int connectionTimeout = 10000;
    private int requestTimeout = 10000;
    private long rollingTimeout = DEFAULT_ROLLING_TIMEOUT;
    private long scaleTimeout = DEFAULT_SCALE_TIMEOUT;
    private int loggingInterval = 20000;
    private long websocketTimeout = DEFAULT_WEBSOCKET_TIMEOUT;
    private long websocketPingInterval = DEFAULT_WEBSOCKET_PING_INTERVAL;
    private String httpProxy;
    private String httpsProxy;
    private String[] noProxy;
    private String userAgent;
    private TlsVersion[] tlsVersions = new TlsVersion[]{TlsVersion.TLS_1_2};
    private Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    public Config() {
        if (!this.tryKubeConfig(this)) {
            this.tryServiceAccount(this);
            this.tryNamespaceFromPath(this);
        }
        this.configFromSysPropsOrEnvVars(this);
        if (!this.masterUrl.toLowerCase().startsWith(HTTP_PROTOCOL_PREFIX) && !this.masterUrl.toLowerCase().startsWith(HTTPS_PROTOCOL_PREFIX)) {
            this.masterUrl = (SSLUtils.isHttpsAvailable(this) ? HTTPS_PROTOCOL_PREFIX : HTTP_PROTOCOL_PREFIX) + this.masterUrl;
        }
        if (!this.masterUrl.endsWith("/")) {
            this.masterUrl = this.masterUrl + "/";
        }
    }

    public Config(String masterUrl, String apiVersion, String namespace, boolean trustCerts, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String username, String password, String oauthToken, int watchReconnectInterval, int watchReconnectLimit, int connectionTimeout, int requestTimeout, long rollingTimeout, long scaleTimeout, int loggingInterval, String httpProxy, String httpsProxy, String[] noProxy, Map<Integer, String> errorMessages, String userAgent, TlsVersion[] tlsVersions, long websocketTimeout, long websocketPingInterval) {
        this.masterUrl = masterUrl;
        this.apiVersion = apiVersion;
        this.namespace = namespace;
        this.trustCerts = trustCerts;
        this.caCertFile = caCertFile;
        this.caCertData = caCertData;
        this.clientCertFile = clientCertFile;
        this.clientCertData = clientCertData;
        this.clientKeyFile = clientKeyFile;
        this.clientKeyData = clientKeyData;
        this.clientKeyAlgo = clientKeyAlgo;
        this.clientKeyPassphrase = clientKeyPassphrase;
        this.username = username;
        this.password = password;
        this.oauthToken = oauthToken;
        this.watchReconnectInterval = watchReconnectInterval;
        this.watchReconnectLimit = watchReconnectLimit;
        this.connectionTimeout = connectionTimeout;
        this.requestTimeout = requestTimeout;
        this.rollingTimeout = rollingTimeout;
        this.scaleTimeout = scaleTimeout;
        this.loggingInterval = loggingInterval;
        this.httpProxy = httpProxy;
        this.httpsProxy = httpsProxy;
        this.noProxy = noProxy;
        this.errorMessages = errorMessages;
        this.userAgent = userAgent;
        this.tlsVersions = tlsVersions;
        this.websocketTimeout = websocketTimeout;
        this.websocketPingInterval = websocketPingInterval;
        if (!this.masterUrl.toLowerCase().startsWith(HTTP_PROTOCOL_PREFIX) && !this.masterUrl.startsWith(HTTPS_PROTOCOL_PREFIX)) {
            this.masterUrl = (SSLUtils.isHttpsAvailable(this) ? HTTPS_PROTOCOL_PREFIX : HTTP_PROTOCOL_PREFIX) + this.masterUrl;
        }
        if (!this.masterUrl.endsWith("/")) {
            this.masterUrl = this.masterUrl + "/";
        }
    }

    public void configFromSysPropsOrEnvVars(Config config) {
        String tlsVersionsVar;
        String configuredWebsocketPingInterval;
        String configuredLoggingInterval;
        String configuredScaleTimeout;
        String configuredRollingTimeout;
        String configuredWatchReconnectLimit;
        config.setTrustCerts(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, config.isTrustCerts()));
        config.setMasterUrl(Utils.getSystemPropertyOrEnvVar(KUBERNETES_MASTER_SYSTEM_PROPERTY, config.getMasterUrl()));
        config.setApiVersion(Utils.getSystemPropertyOrEnvVar(KUBERNETES_API_VERSION_SYSTEM_PROPERTY, config.getApiVersion()));
        config.setNamespace(Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_SYSTEM_PROPERTY, config.getNamespace()));
        config.setCaCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getCaCertFile()));
        config.setCaCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getCaCertData()));
        config.setClientCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getClientCertFile()));
        config.setClientCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getClientCertData()));
        config.setClientKeyFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY, config.getClientKeyFile()));
        config.setClientKeyData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY, config.getClientKeyData()));
        config.setClientKeyAlgo(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY, config.getClientKeyAlgo()));
        config.setClientKeyPassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY, new String(config.getClientKeyPassphrase())));
        config.setUserAgent(Utils.getSystemPropertyOrEnvVar(KUBERNETES_USER_AGENT, config.getUserAgent()));
        config.setOauthToken(Utils.getSystemPropertyOrEnvVar(KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY, config.getOauthToken()));
        config.setUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY, config.getUsername()));
        config.setPassword(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY, config.getPassword()));
        String configuredWatchReconnectInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY);
        if (configuredWatchReconnectInterval != null) {
            config.setWatchReconnectInterval(Integer.parseInt(configuredWatchReconnectInterval));
        }
        if ((configuredWatchReconnectLimit = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY)) != null) {
            config.setWatchReconnectLimit(Integer.parseInt(configuredWatchReconnectLimit));
        }
        if ((configuredRollingTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_ROLLING_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(DEFAULT_ROLLING_TIMEOUT))) != null) {
            config.setRollingTimeout(Long.parseLong(configuredRollingTimeout));
        }
        if ((configuredScaleTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(DEFAULT_SCALE_TIMEOUT))) != null) {
            config.setScaleTimeout(Long.parseLong(configuredScaleTimeout));
        }
        if ((configuredLoggingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(20000))) != null) {
            config.setLoggingInterval(Integer.parseInt(configuredLoggingInterval));
        }
        config.setConnectionTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, config.getConnectionTimeout()));
        config.setRequestTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY, config.getRequestTimeout()));
        String configuredWebsocketTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(config.getWebsocketTimeout()));
        if (configuredWebsocketTimeout != null) {
            config.setWebsocketTimeout(Long.parseLong(configuredWebsocketTimeout));
        }
        if ((configuredWebsocketPingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(config.getWebsocketPingInterval()))) != null) {
            config.setWebsocketPingInterval(Long.parseLong(configuredWebsocketPingInterval));
        }
        config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpProxy()));
        config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpsProxy()));
        config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTPS_PROXY, config.getHttpsProxy()));
        config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTP_PROXY, config.getHttpProxy()));
        String noProxyVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NO_PROXY);
        if (noProxyVar != null) {
            config.setNoProxy(noProxyVar.split(","));
        }
        if ((tlsVersionsVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_TLS_VERSIONS)) != null && !tlsVersionsVar.isEmpty()) {
            String[] tlsVersionsSplit = tlsVersionsVar.split(",");
            TlsVersion[] tlsVersions = new TlsVersion[tlsVersionsSplit.length];
            for (int i = 0; i < tlsVersionsSplit.length; ++i) {
                tlsVersions[i] = TlsVersion.forJavaName((String)tlsVersionsSplit[i]);
            }
            config.setTlsVersions(tlsVersions);
        }
    }

    private boolean tryServiceAccount(Config config) {
        LOGGER.debug("Trying to configure client from service account...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true).booleanValue()) {
            boolean serviceAccountCaCertExists = Files.isRegularFile(new File(KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH).toPath(), new LinkOption[0]);
            if (serviceAccountCaCertExists) {
                LOGGER.debug("Found service account ca cert at: [/var/run/secrets/kubernetes.io/serviceaccount/ca.crt].");
                config.setCaCertFile(KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH);
            } else {
                LOGGER.debug("Did not find service account ca cert at: [/var/run/secrets/kubernetes.io/serviceaccount/ca.crt].");
            }
            try {
                String serviceTokenCandidate = new String(Files.readAllBytes(new File(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH).toPath()));
                if (serviceTokenCandidate != null) {
                    LOGGER.debug("Found service account token at: [/var/run/secrets/kubernetes.io/serviceaccount/token].");
                    config.setOauthToken(serviceTokenCandidate);
                    String txt = "Configured service account doesn't have access. Service account may have been revoked.";
                    config.getErrorMessages().put(401, "Unauthorized! " + txt);
                    config.getErrorMessages().put(403, "Forbidden!" + txt);
                    return true;
                }
                LOGGER.debug("Did not find service account token at: [/var/run/secrets/kubernetes.io/serviceaccount/token].");
            }
            catch (IOException e) {
                LOGGER.warn("Error reading service account token from: [/var/run/secrets/kubernetes.io/serviceaccount/token]. Ignoring.");
            }
        }
        return false;
    }

    private String absolutify(File relativeTo, String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(relativeTo.getParentFile(), filename).getAbsolutePath();
    }

    private boolean tryKubeConfig(Config config) {
        LOGGER.debug("Trying to configure client from Kubernetes config...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true).booleanValue()) {
            File kubeConfigFile = new File(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KUBECONFIG_FILE, new File(this.getHomeDir(), ".kube" + File.separator + "config").toString()));
            boolean kubeConfigFileExists = Files.isRegularFile(kubeConfigFile.toPath(), new LinkOption[0]);
            if (kubeConfigFileExists) {
                LOGGER.debug("Found for Kubernetes config at: [" + kubeConfigFile.getPath() + "].");
                try {
                    io.fabric8.kubernetes.api.model.Config kubeConfig = KubeConfigUtils.parseConfig(kubeConfigFile);
                    Context currentContext = KubeConfigUtils.getCurrentContext(kubeConfig);
                    Cluster currentCluster = KubeConfigUtils.getCluster(kubeConfig, currentContext);
                    if (currentCluster != null) {
                        config.setMasterUrl(currentCluster.getServer());
                        config.setNamespace(currentContext.getNamespace());
                        config.setTrustCerts(currentCluster.getInsecureSkipTlsVerify() != null && currentCluster.getInsecureSkipTlsVerify() != false);
                        config.setCaCertFile(this.absolutify(kubeConfigFile, currentCluster.getCertificateAuthority()));
                        config.setCaCertData(currentCluster.getCertificateAuthorityData());
                        AuthInfo currentAuthInfo = KubeConfigUtils.getUserAuthInfo(kubeConfig, currentContext);
                        if (currentAuthInfo != null) {
                            config.setClientCertFile(this.absolutify(kubeConfigFile, currentAuthInfo.getClientCertificate()));
                            config.setClientCertData(currentAuthInfo.getClientCertificateData());
                            config.setClientKeyFile(this.absolutify(kubeConfigFile, currentAuthInfo.getClientKey()));
                            config.setClientKeyData(currentAuthInfo.getClientKeyData());
                            config.setOauthToken(currentAuthInfo.getToken());
                            config.setUsername(currentAuthInfo.getUsername());
                            config.setPassword(currentAuthInfo.getPassword());
                            config.getErrorMessages().put(401, "Unauthorized! Token may have expired! Please log-in again.");
                            config.getErrorMessages().put(403, "Forbidden! User " + currentContext.getUser() + " doesn't have permission.");
                        }
                        return true;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not load Kubernetes config file from {}", (Object)kubeConfigFile.getPath(), (Object)e);
                }
            } else {
                LOGGER.debug("Did not find Kubernetes config at: [" + kubeConfigFile.getPath() + "]. Ignoring.");
            }
        }
        return false;
    }

    private boolean tryNamespaceFromPath(Config config) {
        LOGGER.debug("Trying to configure client namespace from Kubernetes service account namespace path...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY, true).booleanValue()) {
            String serviceAccountNamespace = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_FILE, KUBERNETES_NAMESPACE_PATH);
            boolean serviceAccountNamespaceExists = Files.isRegularFile(new File(serviceAccountNamespace).toPath(), new LinkOption[0]);
            if (serviceAccountNamespaceExists) {
                LOGGER.debug("Found service account namespace at: [" + serviceAccountNamespace + "].");
                try {
                    String namespace = new String(Files.readAllBytes(new File(serviceAccountNamespace).toPath()));
                    config.setNamespace(namespace.replace(System.lineSeparator(), ""));
                    return true;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading service account namespace from: [" + serviceAccountNamespace + "].", (Throwable)e);
                }
            } else {
                LOGGER.debug("Did not find service account namespace at: [" + serviceAccountNamespace + "]. Ignoring.");
            }
        }
        return false;
    }

    private String getHomeDir() {
        File f;
        String home;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            String homeDir;
            File f2;
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && !homeDrive.isEmpty() && homePath != null && !homePath.isEmpty() && (f2 = new File(homeDir = homeDrive + homePath)).exists() && f2.isDirectory()) {
                return homeDir;
            }
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null && !userProfile.isEmpty() && (f2 = new File(userProfile)).exists() && f2.isDirectory()) {
                return userProfile;
            }
        }
        if ((home = System.getenv("HOME")) != null && !home.isEmpty() && (f = new File(home)).exists() && f.isDirectory()) {
            return home;
        }
        return System.getProperty("user.home", ".");
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public void setClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
    }

    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public void setClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public void setClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
    }

    public String getClientCertData() {
        return this.clientCertData;
    }

    public void setClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public void setClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
    }

    public String getCaCertData() {
        return this.caCertData;
    }

    public void setCaCertData(String caCertData) {
        this.caCertData = caCertData;
    }

    public String getCaCertFile() {
        return this.caCertFile;
    }

    public void setCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public void setTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public void setWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public void setWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
    }

    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    public void setRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public void setScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public void setNoProxy(String[] noProxy) {
        this.noProxy = noProxy;
    }

    public String[] getNoProxy() {
        return this.noProxy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public TlsVersion[] getTlsVersions() {
        return this.tlsVersions;
    }

    public void setTlsVersions(TlsVersion[] tlsVersions) {
        this.tlsVersions = tlsVersions;
    }

    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    public void setWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
    }

    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    public void setWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
    }
}

