/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T, L extends KubernetesResourceList>
implements Watch {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean forceClosed = new AtomicBoolean();
    private final AtomicReference<String> resourceVersion;
    private final BaseOperation<T, L, ?, ?> baseOperation;
    private final Watcher<T> watcher;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final AtomicInteger currentReconnectAttempt = new AtomicInteger(0);
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private WebSocketCall webSocketCall;
    private OkHttpClient clonedClient;

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?, ?> baseOperation, String version, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws InterruptedException, ExecutionException, MalformedURLException {
        if (version == null) {
            L currentList = baseOperation.list();
            this.resourceVersion = new AtomicReference<String>(currentList.getMetadata().getResourceVersion());
        } else {
            this.resourceVersion = new AtomicReference<String>(version);
        }
        this.clonedClient = client.clone();
        this.baseOperation = baseOperation;
        this.watcher = watcher;
        this.reconnectInterval = reconnectInterval;
        this.reconnectLimit = reconnectLimit;
        this.runWatch();
    }

    private final void runWatch() throws MalformedURLException, ExecutionException, InterruptedException {
        URL requestUrl = this.baseOperation.getNamespacedUrl();
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get(requestUrl).newBuilder();
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (Utils.isNotNullOrEmpty(labelQueryParam)) {
            httpUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
        }
        String fieldQueryString = this.baseOperation.getFieldQueryParam();
        String name = this.baseOperation.getName();
        if (name != null && name.length() > 0) {
            if (fieldQueryString.length() > 0) {
                fieldQueryString = fieldQueryString + ",";
            }
            fieldQueryString = fieldQueryString + "metadata.name=" + name;
        }
        if (Utils.isNotNullOrEmpty(fieldQueryString)) {
            httpUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
        }
        httpUrlBuilder.addQueryParameter("resourceVersion", this.resourceVersion.get()).addQueryParameter("watch", "true");
        Request request = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", requestUrl.getProtocol() + "://" + requestUrl.getHost() + ":" + requestUrl.getPort()).build();
        this.clonedClient.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.webSocketCall = WebSocketCall.create(this.clonedClient, request);
        this.webSocketCall.enqueue(new WebSocketListener(){
            private final Logger logger = LoggerFactory.getLogger(this.getClass());

            @Override
            public void onOpen(WebSocket webSocket, Response response) {
                WatchConnectionManager.this.webSocketRef.set(webSocket);
                WatchConnectionManager.this.currentReconnectAttempt.set(0);
                WatchConnectionManager.this.started.set(true);
                WatchConnectionManager.this.queue.add(true);
            }

            @Override
            public void onFailure(IOException e, Response response) {
                if (response != null) {
                    Status status = OperationSupport.createStatus(response);
                    this.logger.error("Exec Failure: HTTP:" + status.getCode() + ". Message:" + status.getMessage(), (Throwable)e);
                    if (!WatchConnectionManager.this.started.get()) {
                        WatchConnectionManager.this.queue.add(new KubernetesClientException(status));
                    }
                } else {
                    this.logger.error("Exec Failure", (Throwable)e);
                    if (!WatchConnectionManager.this.started.get()) {
                        WatchConnectionManager.this.queue.add(KubernetesClientException.launderThrowable(e));
                    }
                }
                try {
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                    return;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                }
                catch (InterruptedException e1) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                    return;
                }
                this.onClose(4000, "Connection unexpectedly closed");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(ResponseBody message) throws IOException {
                String messageSource = null;
                try {
                    messageSource = message.string();
                    WatchEvent event = (WatchEvent)mapper.readValue(messageSource, WatchEvent.class);
                    if (event.getObject() instanceof HasMetadata) {
                        String newResourceVersion;
                        HasMetadata obj = event.getObject();
                        String currentResourceVersion = (String)WatchConnectionManager.this.resourceVersion.get();
                        if (currentResourceVersion.compareTo(newResourceVersion = obj.getMetadata().getResourceVersion()) < 0) {
                            WatchConnectionManager.this.resourceVersion.compareAndSet(currentResourceVersion, newResourceVersion);
                        }
                        Watcher.Action action = Watcher.Action.valueOf(event.getType());
                        WatchConnectionManager.this.watcher.eventReceived(action, obj);
                    } else if (event.getObject() instanceof Status) {
                        Status status = (Status)event.getObject();
                        if (status.getCode() == 410) {
                            WatchConnectionManager.this.close();
                            WatchConnectionManager.this.watcher.onClose(new KubernetesClientException(status));
                            return;
                        }
                        WatchConnectionManager.this.watcher.errorReceived(status);
                    }
                }
                catch (IOException e) {
                    this.logger.error("Could not deserialize watch event: {}", (Object)messageSource, (Object)e);
                }
                catch (ClassCastException e) {
                    this.logger.error("Received wrong type of object for watch", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.logger.error("Invalid event type", (Throwable)e);
                }
                finally {
                    message.close();
                }
            }

            @Override
            public void onPong(Buffer buffer) {
            }

            @Override
            public void onClose(final int code, final String reason) {
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                try {
                    WebSocket ws = (WebSocket)WatchConnectionManager.this.webSocketRef.get();
                    if (ws != null) {
                        ws.close(1000, "Closing...");
                        WatchConnectionManager.this.webSocketRef.set(null);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                WatchConnectionManager.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                WatchConnectionManager.this.queue.clear();
                                WatchConnectionManager.this.runWatch();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof ConnectException)) break block6;
                                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                                    return;
                                }
                                try {
                                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                                }
                                catch (InterruptedException e1) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                                    return;
                                }
                                this.onClose(code, reason);
                            }
                            catch (InterruptedException | MalformedURLException e) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                        }
                    }
                });
            }
        });
    }

    public void waitUntilReady() {
        try {
            Object obj = this.queue.poll(10L, TimeUnit.SECONDS);
            if (Boolean.TRUE.equals(obj)) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public void close() {
        this.forceClosed.set(true);
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.close(1000, "Closing...");
                this.webSocketRef.set(null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }
}

