/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableDeployment;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments")).andReturn(200, (Object)new DeploymentListBuilder().build())).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments")).andReturn(200, (Object)((DeploymentListBuilder)((DeploymentListBuilder)new DeploymentListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/deployments")).andReturn(200, (Object)((DeploymentListBuilder)((DeploymentListBuilder)((DeploymentListBuilder)new DeploymentListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        NamespacedKubernetesClient client = this.getClient();
        DeploymentList deploymentList = (DeploymentList)client.extensions().deployments().list();
        Assert.assertNotNull((Object)deploymentList);
        Assert.assertEquals((long)0L, (long)deploymentList.getItems().size());
        deploymentList = (DeploymentList)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)deploymentList);
        Assert.assertEquals((long)2L, (long)deploymentList.getItems().size());
        deploymentList = (DeploymentList)((FilterWatchListMultiDeletable)client.extensions().deployments().inAnyNamespace()).list();
        Assert.assertNotNull((Object)deploymentList);
        Assert.assertEquals((long)3L, (long)deploymentList.getItems().size());
    }

    @Test
    public void testListWithLables() {
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments?labelSelector=" + DeploymentTest.toUrlEncoded("key1=value1,key2=value2,key3=value3"))).andReturn(200, (Object)new DeploymentListBuilder().build())).always();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments?labelSelector=" + DeploymentTest.toUrlEncoded("key1=value1,key2=value2"))).andReturn(200, (Object)((DeploymentListBuilder)((DeploymentListBuilder)((DeploymentListBuilder)new DeploymentListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        NamespacedKubernetesClient client = this.getClient();
        DeploymentList deploymentList = (DeploymentList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().deployments().withLabel("key1", "value1")).withLabel("key2", "value2")).withLabel("key3", "value3")).list();
        Assert.assertNotNull((Object)deploymentList);
        Assert.assertEquals((long)0L, (long)deploymentList.getItems().size());
        deploymentList = (DeploymentList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().deployments().withLabel("key1", "value1")).withLabel("key2", "value2")).list();
        Assert.assertNotNull((Object)deploymentList);
        Assert.assertEquals((long)3L, (long)deploymentList.getItems().size());
    }

    @Test
    public void testGet() {
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments/deployment1")).andReturn(200, (Object)new DeploymentBuilder().build())).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments/deployment2")).andReturn(200, (Object)new DeploymentBuilder().build())).once();
        NamespacedKubernetesClient client = this.getClient();
        Deployment deployment = (Deployment)((ClientScaleableResource)client.extensions().deployments().withName("deployment1")).get();
        Assert.assertNotNull((Object)deployment);
        deployment = (Deployment)((ClientScaleableResource)client.extensions().deployments().withName("deployment2")).get();
        Assert.assertNull((Object)deployment);
        deployment = (Deployment)((ClientScaleableResource)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("ns1")).withName("deployment2")).get();
        Assert.assertNotNull((Object)deployment);
    }

    @Test
    public void testDelete() {
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments/deployment1")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withObservedGeneration(Long.valueOf(1L))).endStatus()).build())).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments/deployment1")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).withObservedGeneration(Long.valueOf(2L))).endStatus()).build())).times(5);
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments/deployment2")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withObservedGeneration(Long.valueOf(1L))).endStatus()).build())).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments/deployment2")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).withObservedGeneration(Long.valueOf(2L))).endStatus()).build())).times(5);
        NamespacedKubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientScaleableResource)client.extensions().deployments().withName("deployment1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientScaleableResource)client.extensions().deployments().withName("deployment2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientScaleableResource)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("ns1")).withName("deployment2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testDeleteMulti() {
        EditableDeployment deployment1 = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withNamespace("test")).withName("deployment1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withObservedGeneration(Long.valueOf(1L))).endStatus()).build();
        EditableDeployment deployment2 = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withNamespace("ns1")).withName("deployment2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withObservedGeneration(Long.valueOf(1L))).endStatus()).build();
        EditableDeployment deployment3 = ((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment3")).withNamespace("any")).and()).build();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments/deployment1")).andReturn(200, (Object)deployment1)).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/deployments/deployment1")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)new DeploymentBuilder((Deployment)deployment1).editStatus().withReplicas(Integer.valueOf(0))).withObservedGeneration(Long.valueOf(2L))).endStatus()).build())).times(5);
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments/deployment2")).andReturn(200, (Object)deployment2)).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/deployments/deployment2")).andReturn(200, (Object)((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)new DeploymentBuilder((Deployment)deployment2).editStatus().withReplicas(Integer.valueOf(0))).withObservedGeneration(Long.valueOf(2L))).endStatus()).build())).times(5);
        NamespacedKubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().deployments().inAnyNamespace()).delete((Object[])new Deployment[]{deployment1, deployment2});
        Assert.assertTrue((boolean)deleted);
        deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().deployments().inAnyNamespace()).delete((Object[])new Deployment[]{deployment3});
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithNamespaceMismatch() {
        EditableDeployment deployment1 = ((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment1")).withNamespace("test")).and()).build();
        NamespacedKubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("test1")).delete((Object[])new Deployment[]{deployment1});
        Assert.assertNotNull((Object)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditableDeployment deployment1 = ((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment1")).withNamespace("test")).and()).build();
        EditableDeployment deployment2 = ((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("deployment2")).withNamespace("ns1")).and()).build();
        NamespacedKubernetesClient client = this.getClient();
        ((ClientScaleableResource)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("test1")).withName("mydeployment1")).create((Object[])new Deployment[]{deployment1});
    }

    private static final String toUrlEncoded(String str) {
        return str.replaceAll("=", "%3D");
    }
}

