/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import io.fabric8.kubernetes.server.mock.WebSocketSession;

public class ServerResponse {
    private final int statusCode;
    private final String body;
    private final WebSocketSession webSocketSession;
    private final boolean repeatable;

    public ServerResponse(int statusCode, String body, WebSocketSession webSocketSession, boolean repeatable) {
        this.statusCode = statusCode;
        this.body = body;
        this.webSocketSession = webSocketSession;
        this.repeatable = repeatable;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerResponse that = (ServerResponse)o;
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.repeatable != that.repeatable) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return this.webSocketSession != null ? this.webSocketSession.equals(that.webSocketSession) : that.webSocketSession == null;
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.webSocketSession != null ? this.webSocketSession.hashCode() : 0);
        result = 31 * result + (this.repeatable ? 1 : 0);
        return result;
    }
}

