/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DoneableDeployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends HasMetadataOperation<Deployment, DeploymentList, DoneableDeployment, ClientScaleableResource<Deployment, DoneableDeployment>>
implements ClientScaleableResource<Deployment, DoneableDeployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Deployment item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, "extensions", apiVersion, "deployments", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentReaper(this);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentIsScaled();
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    private void waitUntilDeploymentIsScaled() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicDeployment = new AtomicReference();
        Runnable deploymentPoller = new Runnable(){

            @Override
            public void run() {
                Deployment deployment = (Deployment)DeploymentOperationsImpl.this.getMandatory();
                atomicDeployment.set(deployment);
                if (Objects.equals(deployment.getSpec().getReplicas(), deployment.getStatus().getReplicas())) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), DeploymentOperationsImpl.this.namespace});
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Deployment: {} in namespace: {} - giving up", new Object[]{((Deployment)atomicDeployment.get()).getStatus().getReplicas(), ((Deployment)atomicDeployment.get()).getSpec().getReplicas(), ((Deployment)atomicDeployment.get()).getMetadata().getName(), this.namespace});
        }
    }

    private static class DeploymentReaper
    implements Reaper {
        private DeploymentOperationsImpl oper;

        public DeploymentReaper(DeploymentOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public void reap() {
            this.oper.scale(0, true);
        }
    }
}

