/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.server.mock.MockDispatcher;
import io.fabric8.kubernetes.server.mock.MockSSLContextFactory;
import io.fabric8.kubernetes.server.mock.MockServerExpectation;
import io.fabric8.kubernetes.server.mock.MockServerExpectationImpl;
import io.fabric8.kubernetes.server.mock.Pathable;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.ServerRequest;
import io.fabric8.kubernetes.server.mock.ServerResponse;
import io.fabric8.kubernetes.server.mock.Timeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class KubernetesMockServer {
    private final boolean useHttps;
    private MockWebServer server = new MockWebServer();
    private Map<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();

    public KubernetesMockServer() {
        this(true);
    }

    public KubernetesMockServer(boolean useHttps) {
        this.useHttps = useHttps;
    }

    public void init() {
        try {
            if (this.useHttps) {
                this.server.useHttps(MockSSLContextFactory.create().getSocketFactory(), false);
            }
            this.server.setDispatcher((Dispatcher)new MockDispatcher(this.responses));
            ((Timeable)((ReturnOrWebsocketable)((Pathable)this.expect().get()).withPath("/")).andReturn(200, ((RootPathsBuilder)new RootPathsBuilder().addToPaths(this.getRootPaths())).build())).always();
            this.server.start();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String[] getRootPaths() {
        return new String[]{"/api", "/apis/extensions"};
    }

    public void destroy() throws IOException {
        this.server.shutdown();
    }

    public NamespacedKubernetesClient createClient() {
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.server.getUrl("/").toString())).withTrustCerts(true)).withNamespace("test")).build();
        return new DefaultKubernetesClient((Config)config);
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public MockServerExpectation expect() {
        return new MockServerExpectationImpl(this.responses);
    }
}

