/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsListBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class SecurityContextConstraintsTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/securitycontextconstraints")).andReturn(200, ((SecurityContextConstraintsListBuilder)new SecurityContextConstraintsListBuilder().addNewItem().endItem()).build())).once();
        NamespacedKubernetesClient client = this.getClient();
        SecurityContextConstraintsList sccList = (SecurityContextConstraintsList)client.securityContextConstraints().list();
        Assert.assertNotNull((Object)sccList);
        Assert.assertEquals((long)1L, (long)sccList.getItems().size());
    }

    @Test
    public void testDelete() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/securitycontextconstraints/scc1")).andReturn(200, new SecurityContextConstraintsBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/securitycontextconstraints/scc2")).andReturn(200, new SecurityContextConstraintsBuilder().build())).once();
        NamespacedKubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientResource)client.securityContextConstraints().withName("scc1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientResource)client.securityContextConstraints().withName("scc1")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientResource)client.securityContextConstraints().withName("scc2")).delete();
        Assert.assertTrue((boolean)deleted);
    }
}

