/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.EditableReplicationController;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ImageEditReplaceable;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplaceable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.Pathable;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.Timeable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReplicationControllerTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers")).andReturn(200, new ReplicationControllerListBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/ns1/replicationcontrollers")).andReturn(200, ((ReplicationControllerListBuilder)((ReplicationControllerListBuilder)new ReplicationControllerListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        NamespacedKubernetesClient client = this.getClient();
        ReplicationControllerList replicationControllerList = (ReplicationControllerList)client.replicationControllers().list();
        Assert.assertNotNull((Object)replicationControllerList);
        Assert.assertEquals((long)0L, (long)replicationControllerList.getItems().size());
        replicationControllerList = (ReplicationControllerList)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)replicationControllerList);
        Assert.assertEquals((long)2L, (long)replicationControllerList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, new ReplicationControllerBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/ns1/replicationcontrollers/repl2")).andReturn(200, new ReplicationControllerBuilder().build())).once();
        NamespacedKubernetesClient client = this.getClient();
        ReplicationController repl1 = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).get();
        Assert.assertNotNull((Object)repl1);
        repl1 = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl2")).get();
        Assert.assertNull((Object)repl1);
        repl1 = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).withName("repl2")).get();
        Assert.assertNotNull((Object)repl1);
    }

    @Test
    public void testDelete() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).endStatus()).build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).endStatus()).build())).times(5);
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/ns1/replicationcontrollers/repl2")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).endStatus()).build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/ns1/replicationcontrollers/repl2")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).endStatus()).build())).times(5);
        NamespacedKubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientRollableScallableResource)client.replicationControllers().withName("repl2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientRollableScallableResource)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).withName("repl2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testScale() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(5))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).endStatus()).build())).always();
        NamespacedKubernetesClient client = this.getClient();
        ReplicationController repl = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).scale(5);
        Assert.assertNotNull((Object)repl);
        Assert.assertNotNull((Object)repl.getSpec());
        Assert.assertEquals((long)5L, (long)repl.getSpec().getReplicas().intValue());
        Assert.assertEquals((long)1L, (long)repl.getStatus().getReplicas().intValue());
    }

    @Test
    public void testScaleAndWait() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(5))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).endStatus()).build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(5))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(5))).endStatus()).build())).always();
        NamespacedKubernetesClient client = this.getClient();
        ReplicationController repl = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).scale(5, true);
        Assert.assertNotNull((Object)repl);
        Assert.assertNotNull((Object)repl.getSpec());
        Assert.assertEquals((long)5L, (long)repl.getSpec().getReplicas().intValue());
        Assert.assertEquals((long)5L, (long)repl.getStatus().getReplicas().intValue());
    }

    @Ignore
    @Test
    public void testUpdate() {
        EditableReplicationController repl1 = ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().withLabels(new HashMap())).endMetadata()).withNewSpec().addNewContainer().withImage("img1")).endContainer()).endSpec()).endTemplate()).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).endStatus()).build();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, repl1)).once();
        ((Timeable)((ReturnOrWebsocketable)((Pathable)this.expect().put()).withPath("/api/v1/namespaces/test/replicationcontrollers/repl1")).andReturn(200, repl1)).once();
        ((Timeable)((ReturnOrWebsocketable)((Pathable)this.expect().get()).withPath("/api/v1/namespaces/test/replicationcontrollers")).andReturn(200, ((ReplicationControllerListBuilder)new ReplicationControllerListBuilder().withItems(new ReplicationController[]{repl1})).build())).once();
        ((Timeable)((ReturnOrWebsocketable)((Pathable)this.expect().post()).withPath("/api/v1/namespaces/test/replicationcontrollers")).andReturn(201, repl1)).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/pods")).andReturn(200, new KubernetesListBuilder().build())).once();
        NamespacedKubernetesClient client = this.getClient();
        repl1 = (ReplicationController)((ImageEditReplaceable)((TimeoutImageEditReplaceable)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).rolling()).withTimeout(5L, TimeUnit.MINUTES)).updateImage("");
        Assert.assertNotNull((Object)repl1);
    }
}

