/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.server.mock.ServerRequest;
import io.fabric8.kubernetes.server.mock.ServerResponse;
import java.util.Map;
import java.util.Queue;

public class MockDispatcher
extends Dispatcher {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.responses = responses;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String method = request.getMethod();
        String path = request.getPath();
        ServerRequest key = new ServerRequest(method, path);
        ServerRequest keyForAnyMethod = new ServerRequest(path);
        if (this.responses.containsKey(key)) {
            Queue<ServerResponse> queue = this.responses.get(key);
            return this.handleResponse(queue.peek(), queue);
        }
        if (this.responses.containsKey(keyForAnyMethod)) {
            Queue<ServerResponse> queue = this.responses.get(keyForAnyMethod);
            return this.handleResponse(queue.peek(), queue);
        }
        return new MockResponse().setResponseCode(404);
    }

    private MockResponse handleResponse(ServerResponse response, Queue<ServerResponse> queue) {
        if (response == null) {
            return new MockResponse().setResponseCode(404);
        }
        if (response.isToBeRemoved()) {
            queue.remove();
        }
        MockResponse mockResponse = new MockResponse();
        if (response.getWebSocketSession() != null) {
            mockResponse.withWebSocketUpgrade((WebSocketListener)response.getWebSocketSession());
        } else {
            mockResponse.setBody(response.getBody());
            mockResponse.setResponseCode(response.getCode());
        }
        return mockResponse;
    }
}

