/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.EditableJob;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import io.fabric8.kubernetes.api.model.extensions.JobListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class JobTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs")).andReturn(200, new JobListBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/jobs")).andReturn(200, ((JobListBuilder)((JobListBuilder)new JobListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/jobs")).andReturn(200, ((JobListBuilder)((JobListBuilder)((JobListBuilder)new JobListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        JobList jobList = (JobList)client.extensions().jobs().list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)0L, (long)jobList.getItems().size());
        jobList = (JobList)((ClientNonNamespaceOperation)client.extensions().jobs().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)2L, (long)jobList.getItems().size());
        jobList = (JobList)((FilterWatchListMultiDeletable)client.extensions().jobs().inAnyNamespace()).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)3L, (long)jobList.getItems().size());
    }

    @Test
    public void testListWithLables() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs?labelSelector=" + JobTest.toUrlEncoded("key1=value1,key2=value2,key3=value3"))).andReturn(200, new JobListBuilder().build())).always();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs?labelSelector=" + JobTest.toUrlEncoded("key1=value1,key2=value2"))).andReturn(200, ((JobListBuilder)((JobListBuilder)((JobListBuilder)new JobListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        JobList jobList = (JobList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().jobs().withLabel("key1", "value1")).withLabel("key2", "value2")).withLabel("key3", "value3")).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)0L, (long)jobList.getItems().size());
        jobList = (JobList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().jobs().withLabel("key1", "value1")).withLabel("key2", "value2")).list();
        Assert.assertNotNull((Object)jobList);
        Assert.assertEquals((long)3L, (long)jobList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs/job1")).andReturn(200, new JobBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/jobs/job2")).andReturn(200, new JobBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Job job = (Job)((ClientResource)client.extensions().jobs().withName("job1")).get();
        Assert.assertNotNull((Object)job);
        job = (Job)((ClientResource)client.extensions().jobs().withName("job2")).get();
        Assert.assertNull((Object)job);
        job = (Job)((ClientResource)((ClientNonNamespaceOperation)client.extensions().jobs().inNamespace("ns1")).withName("job2")).get();
        Assert.assertNotNull((Object)job);
    }

    @Test
    public void testDelete() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs/job1")).andReturn(200, new JobBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/jobs/job2")).andReturn(200, new JobBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientResource)client.extensions().jobs().withName("job1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientResource)client.extensions().jobs().withName("job2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientResource)((ClientNonNamespaceOperation)client.extensions().jobs().inNamespace("ns1")).withName("job2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testDeleteMulti() {
        EditableJob job1 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job1")).withNamespace("test")).and()).build();
        EditableJob job2 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job2")).withNamespace("ns1")).and()).build();
        EditableJob job3 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job3")).withNamespace("any")).and()).build();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/jobs/job1")).andReturn(200, job1)).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/jobs/job2")).andReturn(200, job2)).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().jobs().inAnyNamespace()).delete((Object[])new Job[]{job1, job2});
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().jobs().inAnyNamespace()).delete((Object[])new Job[]{job3});
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithNamespaceMismatch() {
        EditableJob job1 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job1")).withNamespace("test")).and()).build();
        EditableJob job2 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientNonNamespaceOperation)client.extensions().jobs().inNamespace("test1")).delete((Object[])new Job[]{job1});
        Assert.assertNotNull((Object)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditableJob job1 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job1")).withNamespace("test")).and()).build();
        EditableJob job2 = ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("job2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        ((ClientResource)((ClientNonNamespaceOperation)client.extensions().jobs().inNamespace("test1")).withName("myjob1")).create((Object[])new Job[]{job1});
    }

    private static final String toUrlEncoded(String str) {
        return str.replaceAll("=", "%3D");
    }
}

