/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.EditableIngress;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class IngressTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses")).andReturn(200, new IngressListBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/ingresses")).andReturn(200, ((IngressListBuilder)((IngressListBuilder)new IngressListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/ingresses")).andReturn(200, ((IngressListBuilder)((IngressListBuilder)((IngressListBuilder)new IngressListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        IngressList ingressList = (IngressList)client.extensions().ingress().list();
        Assert.assertNotNull((Object)ingressList);
        Assert.assertEquals((long)0L, (long)ingressList.getItems().size());
        ingressList = (IngressList)((ClientNonNamespaceOperation)client.extensions().ingress().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)ingressList);
        Assert.assertEquals((long)2L, (long)ingressList.getItems().size());
        ingressList = (IngressList)((FilterWatchListMultiDeletable)client.extensions().ingress().inAnyNamespace()).list();
        Assert.assertNotNull((Object)ingressList);
        Assert.assertEquals((long)3L, (long)ingressList.getItems().size());
    }

    @Test
    public void testListWithLables() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses?labelSelector=" + IngressTest.toUrlEncoded("key1=value1,key2=value2,key3=value3"))).andReturn(200, new IngressListBuilder().build())).always();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses?labelSelector=" + IngressTest.toUrlEncoded("key1=value1,key2=value2"))).andReturn(200, ((IngressListBuilder)((IngressListBuilder)((IngressListBuilder)new IngressListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        IngressList ingressList = (IngressList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().ingress().withLabel("key1", "value1")).withLabel("key2", "value2")).withLabel("key3", "value3")).list();
        Assert.assertNotNull((Object)ingressList);
        Assert.assertEquals((long)0L, (long)ingressList.getItems().size());
        ingressList = (IngressList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.extensions().ingress().withLabel("key1", "value1")).withLabel("key2", "value2")).list();
        Assert.assertNotNull((Object)ingressList);
        Assert.assertEquals((long)3L, (long)ingressList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses/ingress1")).andReturn(200, new IngressBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/ingresses/ingress2")).andReturn(200, new IngressBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Ingress ingress = (Ingress)((ClientResource)client.extensions().ingress().withName("ingress1")).get();
        Assert.assertNotNull((Object)ingress);
        ingress = (Ingress)((ClientResource)client.extensions().ingress().withName("ingress2")).get();
        Assert.assertNull((Object)ingress);
        ingress = (Ingress)((ClientResource)((ClientNonNamespaceOperation)client.extensions().ingress().inNamespace("ns1")).withName("ingress2")).get();
        Assert.assertNotNull((Object)ingress);
    }

    @Test
    public void testDelete() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses/ingress1")).andReturn(200, new IngressBuilder().build())).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/ingresses/ingress2")).andReturn(200, new IngressBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientResource)client.extensions().ingress().withName("ingress1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientResource)client.extensions().ingress().withName("ingress2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientResource)((ClientNonNamespaceOperation)client.extensions().ingress().inNamespace("ns1")).withName("ingress2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testDeleteMulti() {
        EditableIngress ingress1 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress1")).withNamespace("test")).and()).build();
        EditableIngress ingress2 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress2")).withNamespace("ns1")).and()).build();
        EditableIngress ingress3 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress3")).withNamespace("any")).and()).build();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/test/ingresses/ingress1")).andReturn(200, ingress1)).once();
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/apis/extensions/v1beta1/namespaces/ns1/ingresses/ingress2")).andReturn(200, ingress2)).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().ingress().inAnyNamespace()).delete((Object[])new Ingress[]{ingress1, ingress2});
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((FilterWatchListMultiDeletable)client.extensions().ingress().inAnyNamespace()).delete((Object[])new Ingress[]{ingress3});
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithNamespaceMismatch() {
        EditableIngress ingress1 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress1")).withNamespace("test")).and()).build();
        EditableIngress ingress2 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientNonNamespaceOperation)client.extensions().ingress().inNamespace("test1")).delete((Object[])new Ingress[]{ingress1});
        Assert.assertNotNull((Object)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditableIngress ingress1 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress1")).withNamespace("test")).and()).build();
        EditableIngress ingress2 = ((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ingress2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        ((ClientResource)((ClientNonNamespaceOperation)client.extensions().ingress().inNamespace("test1")).withName("myingress1")).create((Object[])new Ingress[]{ingress1});
    }

    private static final String toUrlEncoded(String str) {
        return str.replaceAll("=", "%3D");
    }
}

