/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.server.mock.WebSocketMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import okio.ByteString;

public class WebSocketSession
implements WebSocketListener {
    private final WebSocketMessage[] open;
    private final WebSocketMessage failure;
    private final Exception cause;
    private final Map<Object, Queue<WebSocketMessage>> requestEvents = new HashMap<Object, Queue<WebSocketMessage>>();
    private final List<WebSocketMessage> timedEvents = new ArrayList<WebSocketMessage>();
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public WebSocketSession(WebSocketMessage[] open, WebSocketMessage failure, Exception cause) {
        this.open = open;
        this.failure = failure;
        this.cause = cause;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.webSocketRef.set(webSocket);
        for (WebSocketMessage msg : this.open) {
            this.send(msg);
        }
        for (WebSocketMessage msg : this.timedEvents) {
            this.send(msg);
        }
        this.checkIfShouldClose();
    }

    public void onFailure(IOException e, Response response) {
    }

    public void onMessage(ResponseBody message) throws IOException {
        String in = this.read(message);
        Queue<WebSocketMessage> queue = this.requestEvents.get(in);
        if (queue != null && !queue.isEmpty()) {
            WebSocketMessage msg = queue.peek();
            this.send(msg);
            if (msg.isToBeRemoved()) {
                queue.remove();
            }
            this.checkIfShouldClose();
        } else {
            this.webSocketRef.get().close(0, "Unexpected message:" + in);
        }
    }

    public void onPong(Buffer payload) {
    }

    public void onClose(int code, String reason) {
    }

    public Map<Object, Queue<WebSocketMessage>> getRequestEvents() {
        return this.requestEvents;
    }

    public List<WebSocketMessage> getTimedEvents() {
        return this.timedEvents;
    }

    private void checkIfShouldClose() {
        if (this.requestEvents.isEmpty()) {
            try {
                this.executor.shutdown();
                if (this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    this.webSocketRef.get().close(1000, "Closing...");
                } else {
                    this.executor.shutdownNow();
                    this.webSocketRef.get().close(1000, "Closing...");
                }
            }
            catch (Throwable t) {
                throw KubernetesClientException.launderThrowable((Throwable)t);
            }
        }
    }

    private void send(final WebSocketMessage message) {
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    WebSocket ws = (WebSocket)WebSocketSession.this.webSocketRef.get();
                    if (ws != null) {
                        ws.sendMessage(RequestBody.create((MediaType)WebSocket.BINARY, (byte[])message.getBytes()));
                    }
                }
                catch (IOException e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        }, (long)message.getDelay(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(ResponseBody message) throws IOException {
        try {
            byte streamID = message.source().readByte();
            ByteString byteString = message.source().readByteString();
            if (byteString.size() > 0) {
                switch (streamID) {
                    case 1: 
                    case 2: 
                    case 3: {
                        String string = byteString.toString();
                        return string;
                    }
                }
                throw new IOException("Unknown stream ID " + streamID);
            }
        }
        finally {
            message.close();
        }
        throw new IllegalArgumentException("Not a string message");
    }
}

