/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.server.mock.Emitable;
import io.fabric8.kubernetes.server.mock.EventDoneable;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.kubernetes.server.mock.WebSocketMessage;
import io.fabric8.kubernetes.server.mock.WebSocketSession;
import io.fabric8.kubernetes.server.mock.WebSocketSessionBuilder;
import java.util.ArrayDeque;
import java.util.Queue;

public class InlineWebSocketSessionBuilder<T>
implements WebSocketSessionBuilder<T>,
EventDoneable<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Function<WebSocketSession, T> function;
    private WebSocketSession session;

    public InlineWebSocketSessionBuilder(Function<WebSocketSession, T> function) {
        this.function = function;
    }

    @Override
    public EventDoneable<T> open(Object ... response) {
        this.session = new WebSocketSession(this.toWebSocketMessages(response), null, null);
        return this;
    }

    @Override
    public T failure(Object response, Exception e) {
        return (T)this.function.apply((Object)new WebSocketSession(null, this.toWebSocketMessage(response), e));
    }

    public T done() {
        return (T)this.function.apply((Object)this.session);
    }

    @Override
    public Emitable<Timeable<EventDoneable<T>>> expect(final Object in) {
        return new Emitable<Timeable<EventDoneable<T>>>(){

            @Override
            public Timeable<EventDoneable<T>> andEmit(final Object event) {
                return new Timeable<EventDoneable<T>>(){

                    @Override
                    public EventDoneable<T> always() {
                        InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, false));
                        return InlineWebSocketSessionBuilder.this;
                    }

                    @Override
                    public EventDoneable<T> once() {
                        InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, true));
                        return InlineWebSocketSessionBuilder.this;
                    }

                    @Override
                    public EventDoneable<T> times(int times) {
                        for (int i = 0; i < times; ++i) {
                            InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, true));
                        }
                        return InlineWebSocketSessionBuilder.this;
                    }
                };
            }
        };
    }

    @Override
    public Emitable<EventDoneable<T>> waitFor(long millis) {
        return new Emitable<EventDoneable<T>>(){

            @Override
            public EventDoneable<T> andEmit(Object event) {
                InlineWebSocketSessionBuilder.this.session.getTimedEvents().add(InlineWebSocketSessionBuilder.this.toWebSocketMessage(event));
                return InlineWebSocketSessionBuilder.this;
            }
        };
    }

    private WebSocketMessage[] toWebSocketMessages(Object ... content) {
        WebSocketMessage[] response = new WebSocketMessage[content.length];
        for (int i = 0; i < content.length; ++i) {
            response[i] = this.toWebSocketMessage(content[i]);
        }
        return response;
    }

    private WebSocketMessage toWebSocketMessage(Object content) {
        return this.toWebSocketMessage(0L, content, true);
    }

    private WebSocketMessage toWebSocketMessage(Long delay, Object content) {
        return this.toWebSocketMessage(delay, content, true);
    }

    private WebSocketMessage toWebSocketMessage(Object content, Boolean toBeRemoved) {
        return this.toWebSocketMessage(0L, content, toBeRemoved);
    }

    private WebSocketMessage toWebSocketMessage(Long delay, Object content, Boolean toBeRemoved) {
        if (content instanceof String) {
            return new WebSocketMessage(delay, (String)content, toBeRemoved);
        }
        if (content instanceof WebSocketMessage) {
            return (WebSocketMessage)content;
        }
        try {
            return this.toWebSocketMessage(delay, MAPPER.writeValueAsString(content), toBeRemoved);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void enqueue(Object req, WebSocketMessage resp) {
        Queue<WebSocketMessage> queuedResponses = this.session.getRequestEvents().get(req);
        if (queuedResponses == null) {
            queuedResponses = new ArrayDeque<WebSocketMessage>();
            this.session.getRequestEvents().put(req, queuedResponses);
        }
        queuedResponses.add(resp);
    }
}

