/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.ComponentCondition;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ComponentStatusListBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatusListFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class ComponentStatusTest
extends KubernetesMockServerTestBase {
    ComponentStatus status = ((ComponentStatusBuilder)new ComponentStatusBuilder().withConditions(new ComponentCondition[]{new ComponentCondition(null, "ok", "True", "Healthy")})).build();
    ComponentStatusList list = ((ComponentStatusListBuilder)((ComponentStatusListFluent.ItemsNested)new ComponentStatusListBuilder().addNewItem().addNewCondition().and()).endItem()).build();

    @Test
    public void testComponentStatus() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/componentstatuses/scheduler")).andReturn(200, this.status)).once();
        KubernetesClient client = this.getClient();
        ComponentStatus stat = (ComponentStatus)((ClientResource)client.componentstatuses().withName("scheduler")).get();
        Assert.assertNotNull((Object)stat);
        Assert.assertEquals((long)1L, (long)stat.getConditions().size());
    }

    @Test
    public void testComponentStatusList() {
        ((Timeable)((ReturnOrWebsocketable)this.expect().withPath("/api/v1/namespaces/test/componentstatuses")).andReturn(200, this.status)).once();
        KubernetesClient client = this.getClient();
        ComponentStatusList stats = (ComponentStatusList)client.componentstatuses().list();
        Assert.assertNotNull((Object)stats);
    }
}

