/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.server.mock.InlineWebSocketSessionBuilder;
import io.fabric8.kubernetes.server.mock.MockServerExpectation;
import io.fabric8.kubernetes.server.mock.Pathable;
import io.fabric8.kubernetes.server.mock.ReturnOrWebsocketable;
import io.fabric8.kubernetes.server.mock.ServerRequest;
import io.fabric8.kubernetes.server.mock.ServerResponse;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.kubernetes.server.mock.WebSocketSession;
import io.fabric8.kubernetes.server.mock.WebSocketSessionBuilder;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;

public class MockServerExpectationImpl
implements MockServerExpectation {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String method;
    private final String path;
    private final int statusCode;
    private final String body;
    private final int times;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockServerExpectationImpl(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this("", null, 200, null, 1, responses);
    }

    public MockServerExpectationImpl(String method, String path, int statusCode, String body, int times, Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.method = method;
        this.path = path;
        this.statusCode = statusCode;
        this.body = body;
        this.times = times;
        this.responses = responses;
    }

    @Override
    public Pathable<ReturnOrWebsocketable<Timeable<Void>>> any() {
        return new MockServerExpectationImpl("", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<Timeable<Void>>> post() {
        return new MockServerExpectationImpl("post", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<Timeable<Void>>> get() {
        return new MockServerExpectationImpl("get", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<Timeable<Void>>> put() {
        return new MockServerExpectationImpl("put", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<Timeable<Void>>> delete() {
        return new MockServerExpectationImpl("delete", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public ReturnOrWebsocketable<Timeable<Void>> withPath(String path) {
        return new MockServerExpectationImpl(this.method, path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Timeable<Void> andReturn(int statusCode, Object content) {
        if (content instanceof String) {
            return new MockServerExpectationImpl(this.method, this.path, statusCode, (String)content, this.times, this.responses);
        }
        try {
            return new MockServerExpectationImpl(this.method, this.path, statusCode, MAPPER.writeValueAsString(content), this.times, this.responses);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void always() {
        this.enqueue(new ServerRequest(this.method, this.path), new ServerResponse(this.statusCode, this.body, null, false));
        return null;
    }

    @Override
    public Void once() {
        this.enqueue(new ServerRequest(this.method, this.path), new ServerResponse(this.statusCode, this.body, null, true));
        return null;
    }

    @Override
    public Void times(int times) {
        for (int i = 0; i < times; ++i) {
            this.once();
        }
        return null;
    }

    private void enqueue(ServerRequest req, ServerResponse resp) {
        Queue<ServerResponse> queuedResponses = this.responses.get(req);
        if (queuedResponses == null) {
            queuedResponses = new ArrayDeque<ServerResponse>();
            this.responses.put(req, queuedResponses);
        }
        queuedResponses.add(resp);
    }

    @Override
    public WebSocketSessionBuilder<Timeable<Void>> andUpgradeToWebSocket() {
        return new InlineWebSocketSessionBuilder<Timeable<Void>>(new Function<WebSocketSession, Timeable<Void>>(){

            public Timeable<Void> apply(final WebSocketSession webSocketSession) {
                return new Timeable<Void>(){

                    @Override
                    public Void always() {
                        MockServerExpectationImpl.this.enqueue(new ServerRequest(MockServerExpectationImpl.this.method, MockServerExpectationImpl.this.path), new ServerResponse(MockServerExpectationImpl.this.statusCode, null, webSocketSession, false));
                        return null;
                    }

                    @Override
                    public Void once() {
                        MockServerExpectationImpl.this.enqueue(new ServerRequest(MockServerExpectationImpl.this.method, MockServerExpectationImpl.this.path), new ServerResponse(MockServerExpectationImpl.this.statusCode, null, webSocketSession, true));
                        return null;
                    }

                    @Override
                    public Void times(int times) {
                        for (int i = 0; i < times; ++i) {
                            this.once();
                        }
                        return null;
                    }
                };
            }
        });
    }
}

